/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Force;
import com.tyr.ForceTracker;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.AttackGroup;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class SiegeNaturalSolution
extends Solution
implements Force {
    private AttackGroup attackGroup;
    private Position attackTarget;
    private Position siegeTarget;
    private int siegeFrame = -10000;
    public int siegeTime = 400;
    public int siegeBuildingTime = 100;
    private ArrayList<Agent> besiegingTanks = new ArrayList();
    private Position center;
    private int updateFrame;
    private boolean done;

    public SiegeNaturalSolution(Task task, Position attackTarget) {
        super(task);
        this.attackTarget = attackTarget;
        this.attackGroup = new AttackGroup(attackTarget);
        ForceTracker.register(this);
    }

    public void setTarget(Position attackTarget) {
        this.attackTarget = attackTarget;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Agent agent;
        StopWatch watch = new StopWatch();
        ArrayList<Long> times = new ArrayList<Long>();
        watch.start();
        Tyr.drawCircle(this.attackTarget, Color.Orange, 64);
        if (this.besiegingTanks.size() == 0) {
            this.siegeFrame = -10000;
        }
        if (this.isSieging()) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.isCloaked() || enemy.getType().isFlyer() || !(this.siegeTarget.getDistance(enemy.getPosition()) <= (double)UnitType.Terran_Siege_Tank_Siege_Mode.sightRange())) continue;
                if (enemy.getType().isBuilding()) {
                    this.siegeFrame = Math.min(this.siegeFrame, game.getFrameCount() + this.siegeTime - this.siegeBuildingTime);
                    continue;
                }
                this.siegeFrame = game.getFrameCount();
                break;
            }
        }
        times.add(watch.time());
        block1: for (Agent agent2 : this.attackGroup.units) {
            if (this.siegeFrame >= game.getFrameCount()) break;
            if (!agent2.isTank()) continue;
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.isCloaked() || enemy.getType().isFlyer() || enemy.getType().isWorker() || agent2.distanceSquared(enemy) > UnitType.Terran_Siege_Tank_Siege_Mode.sightRange() * UnitType.Terran_Siege_Tank_Siege_Mode.sightRange()) continue;
                this.siegeTarget = agent2.unit.getPosition();
                this.siegeFrame = game.getFrameCount();
                continue block1;
            }
        }
        times.add(watch.time());
        if (this.isSieging()) {
            Tyr.drawCircle(this.siegeTarget, Color.Blue, 256);
            game.drawTextMap(this.siegeTarget.getX(), this.siegeTarget.getY(), String.valueOf(game.getFrameCount() - this.siegeFrame));
            int i = this.attackGroup.units.size() - 1;
            while (i >= 0) {
                int distanceSq;
                agent = (Agent)this.attackGroup.units.get(i);
                if (agent.isTank() && ((distanceSq = agent.distanceSquared(this.siegeTarget)) <= 65536 && agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || distanceSq <= 9216)) {
                    this.attackGroup.units.remove(i);
                    agent.order(new None(agent));
                    this.besiegingTanks.add(agent);
                }
                --i;
            }
        }
        times.add(watch.time());
        int i = this.attackGroup.units.size() - 1;
        while (i >= 0) {
            agent = (Agent)this.attackGroup.units.get(i);
            if (agent.isTank() && agent.distanceSquared(this.attackTarget) <= UnitType.Terran_Siege_Tank_Siege_Mode.sightRange() * UnitType.Terran_Siege_Tank_Siege_Mode.sightRange()) {
                this.attackGroup.units.remove(i);
                agent.order(new None(agent));
                this.besiegingTanks.add(agent);
            }
            --i;
        }
        times.add(watch.time());
        i = this.besiegingTanks.size() - 1;
        while (i >= 0) {
            agent = this.besiegingTanks.get(i);
            if (agent.distanceSquared(this.attackTarget) > UnitType.Terran_Siege_Tank_Siege_Mode.sightRange() * UnitType.Terran_Siege_Tank_Siege_Mode.sightRange() && !this.isSieging() || agent.distanceSquared(this.siegeTarget) > 65536) {
                this.besiegingTanks.remove(i);
                this.attackGroup.add(agent);
            } else {
                agent.drawCircle(Color.Green);
                if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
                    agent.unit.siege();
                }
            }
            --i;
        }
        times.add(watch.time());
        if (!this.isSieging()) {
            for (Agent agent3 : this.attackGroup.units) {
                if (agent3.distanceSquared(this.attackTarget) > 10000) continue;
                this.done = true;
            }
        }
        times.add(watch.time());
        DebugMessages.addMessage("Siege " + this.attackGroup.units.size() + " " + this.besiegingTanks.size() + (this.isSieging() ? " " + (game.getFrameCount() - this.siegeFrame) : ""));
        this.attackGroup.cleanup();
        if (this.isSieging()) {
            this.attackGroup.setTarget(this.siegeTarget);
        } else {
            this.attackGroup.setTarget(this.attackTarget);
        }
        this.attackGroup.onFrame(game, self, bot);
        times.add(watch.time());
        i = 0;
        while (i < times.size()) {
            if ((Long)times.get(i) > 50L) {
                DebugMessages.addMessage("SiegeNatural times(" + i + ") = " + times.get(i));
            }
            ++i;
        }
    }

    public void add(Agent agent) {
        this.attackGroup.add(agent);
    }

    public void done(UnitGroup unitGroup) {
        for (Agent unit : this.attackGroup.units) {
            unitGroup.add(unit);
            unit.order(new None(unit));
        }
        this.attackGroup.units = new ArrayList();
    }

    public void clear() {
        this.attackGroup.clear();
    }

    private boolean isSieging() {
        return this.siegeFrame + this.siegeTime >= Tyr.game.getFrameCount();
    }

    @Override
    public int size() {
        return this.attackGroup.units.size();
    }

    @Override
    public Position getCenter() {
        if (this.updateFrame == Tyr.game.getFrameCount()) {
            return this.center;
        }
        if (this.isSieging()) {
            return this.siegeTarget;
        }
        int totalX = 0;
        int totalY = 0;
        for (Agent agent : this.attackGroup.units) {
            totalX += agent.unit.getX();
            totalY += agent.unit.getY();
        }
        this.center = new Position(totalX / this.attackGroup.units.size(), totalY / this.attackGroup.units.size());
        this.updateFrame = Tyr.game.getFrameCount();
        return this.center;
    }

    @Override
    public boolean disabled() {
        return this.attackGroup.units.size() + this.besiegingTanks.size() == 0;
    }

    @Override
    public boolean done() {
        return this.done;
    }
}

