/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwta.BaseLocation;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import java.util.ArrayList;
import java.util.List;

public class ScoutExpansionsSolution
extends Solution {
    private List<Agent> scouts = new ArrayList<Agent>();
    private int currentPos;
    private int currentDir = 1;
    private int enemyExpandPos = -1;
    private Position target;

    public ScoutExpansionsSolution(Task task) {
        super(task);
        this.determineTarget();
    }

    public ScoutExpansionsSolution(Task task, int startDir) {
        super(task);
        this.currentDir = startDir;
        this.determineTarget();
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        this.determineTarget();
        Agent.clean(this.scouts);
        DebugMessages.addMessage("Scouts: " + this.scouts.size());
        for (Agent scout : this.scouts) {
            if (this.target == null) continue;
            scout.move(this.target);
            game.drawLineMap(this.target, scout.unit.getPosition(), Color.Yellow);
        }
    }

    public void add(Agent agent) {
        if (agent != null) {
            this.scouts.add(agent);
        }
    }

    public int count() {
        return this.scouts.size();
    }

    private boolean determineTarget() {
        int i;
        boolean result = false;
        ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
        if (orderedExpands != null) {
            i = 0;
            while (i < orderedExpands.size()) {
                Position pos = orderedExpands.get(i);
                Tyr.drawCircle(pos, Color.Red, 32);
                Tyr.game.drawTextMap(pos.getX(), pos.getY(), String.valueOf(i));
                ++i;
            }
            if (this.target != null) {
                Tyr.drawCircle(this.target, Color.Red);
            }
        }
        if (this.target == null) {
            if (orderedExpands == null) {
                DebugMessages.addMessage("orderedExpands is null.");
                return false;
            }
            this.currentPos = EnemyManager.getManager().getSelfPos();
            if (this.currentPos != -1) {
                this.target = orderedExpands.get(this.currentPos);
                result = true;
            }
        }
        i = 0;
        while (i < 2 * orderedExpands.size()) {
            boolean isIsland = false;
            for (BaseLocation loc : Tyr.bot.expands) {
                if (!loc.isIsland() || !(loc.getDistance(this.target) <= 128.0)) continue;
                isIsland = true;
            }
            boolean enemyClose = false;
            if (this.target != null) {
                for (EnemyPosition pos : EnemyManager.getManager().enemyBuildingMemory) {
                    if (pos.distanceSq(this.target) > 90000) continue;
                    enemyClose = true;
                    break;
                }
            }
            if (!enemyClose && !isIsland && this.target != null && !Tyr.game.isVisible(Tyr.positionToTile(this.target))) break;
            this.nextTarget();
            this.determineEnemyExpand();
            while (this.currentPos == this.enemyExpandPos) {
                this.nextTarget();
            }
            result = true;
            ++i;
        }
        return result;
    }

    private void determineEnemyExpand() {
        if (this.enemyExpandPos >= 0 || Tyr.bot.suspectedEnemy.size() > 1) {
            return;
        }
        ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
        if (orderedExpands == null) {
            return;
        }
        Position exit = SpaceManager.getExit(Tyr.bot.suspectedEnemy.get(0).getPosition());
        int closest = -1;
        int bestDist = Integer.MAX_VALUE;
        int i = 0;
        while (i < orderedExpands.size()) {
            int dist = (int)orderedExpands.get(i).getDistance(exit);
            if (dist < bestDist) {
                closest = i;
                bestDist = dist;
            }
            ++i;
        }
        this.enemyExpandPos = closest;
    }

    private void nextTarget() {
        ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
        if (orderedExpands == null) {
            return;
        }
        this.currentPos += this.currentDir;
        if (this.currentPos >= orderedExpands.size() || this.currentPos < 0) {
            this.currentDir *= -1;
            this.currentPos += 2 * this.currentDir;
        }
        this.target = orderedExpands.get(this.currentPos);
    }
}

