/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import com.tyr.EnemyManager;
import com.tyr.OrderedExpands;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;
import java.util.List;

public class ObserverSolution
extends Solution {
    private static ObserverSolution solution;
    List<Agent> observers = new ArrayList<Agent>();
    private Agent baseObserver;
    private Agent armyObserver;
    private Agent cwObserver;
    private Agent ccwObserver;
    private OrderedExpands cwExpands = new OrderedExpands(true, false, true, true);

    public ObserverSolution(Task task) {
        super(task);
        solution = this;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.baseObserver != null && this.baseObserver.isDead()) {
            this.baseObserver = null;
        }
        if (this.armyObserver != null && this.armyObserver.isDead()) {
            this.armyObserver = null;
        }
        if (this.cwObserver != null && this.cwObserver.isDead()) {
            this.cwObserver = null;
        }
        if (this.ccwObserver != null && this.ccwObserver.isDead()) {
            this.ccwObserver = null;
        }
        if (this.armyObserver == null && this.observers.size() > 0) {
            this.armyObserver = this.observers.get(this.observers.size() - 1);
            this.observers.remove(this.observers.size() - 1);
        }
        if (this.cwObserver == null && this.observers.size() > 0) {
            this.cwObserver = this.observers.get(this.observers.size() - 1);
            this.observers.remove(this.observers.size() - 1);
        }
        int i = this.observers.size() - 1;
        while (i >= 0) {
            if (this.observers.get(i) == null || this.observers.get(i).isDead()) {
                this.observers.remove(i);
            }
            --i;
        }
        if (this.armyObserver != null) {
            int distSq = 160000;
            Position enemyPos = null;
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                int newDistSq;
                if (enemy.getType() != UnitType.Zerg_Lurker && enemy.getType() != UnitType.Protoss_Dark_Templar || (newDistSq = this.armyObserver.distanceSquared(enemy)) >= distSq) continue;
                boolean unitClose = false;
                for (Unit unit : Tyr.self.getUnits()) {
                    if (unit.getType().groundWeapon() == WeaponType.None || unit.getType().isBuilding() || unit.getType().isWorker() || !unit.isCompleted() || PositionUtil.distanceSq(unit, enemy) > 90000) continue;
                    unitClose = true;
                    break;
                }
                if (!unitClose) continue;
                distSq = newDistSq;
                enemyPos = enemy.getPosition();
            }
            if (enemyPos != null) {
                this.armyObserver.unit.move(enemyPos);
                game.drawLineMap(this.armyObserver.unit.getX(), this.armyObserver.unit.getY(), enemyPos.getX(), enemyPos.getY(), Color.Green);
            } else {
                Position armyPos = this.getArmyPos();
                if (armyPos != null) {
                    this.armyObserver.unit.move(armyPos);
                    game.drawLineMap(this.armyObserver.unit.getX(), this.armyObserver.unit.getY(), armyPos.getX(), armyPos.getY(), Color.Green);
                }
            }
        }
        Position cwPos = null;
        if (this.cwObserver != null) {
            cwPos = this.getTarget();
        }
        if (cwPos != null) {
            this.cwObserver.unit.move(cwPos);
            game.drawLineMap(this.cwObserver.unit.getX(), this.cwObserver.unit.getY(), cwPos.getX(), cwPos.getY(), Color.Green);
        }
    }

    public void add(Agent agent) {
        this.observers.add(agent);
    }

    public Position getArmyPos() {
        Unit closest = null;
        int distance = Integer.MAX_VALUE;
        Position target = null;
        if (Tyr.bot.suspectedEnemy.size() > 0) {
            target = Tyr.bot.suspectedEnemy.get(0).getPosition();
        } else if (EnemyManager.getManager().enemyBuildingMemory.size() > 0) {
            target = EnemyManager.getManager().enemyBuildingMemory.iterator().next().pos;
        }
        if (target != null) {
            for (Unit unit : Tyr.self.getUnits()) {
                if (unit.getType().groundWeapon() == WeaponType.None && unit.getType() != UnitType.Protoss_Carrier || unit.getType().isBuilding() || unit.getType().isWorker() || unit.getType() == UnitType.Protoss_Zealot || unit.getType() == UnitType.Protoss_Dark_Templar || unit.getType() == UnitType.Protoss_Interceptor || !unit.isCompleted() || unit.getDistance(target) >= distance) continue;
                distance = unit.getDistance(target);
                closest = unit;
            }
        }
        if (closest == null) {
            return null;
        }
        return closest.getPosition();
    }

    public void done(UnitGroup unitGroup) {
        for (Agent unit : this.observers) {
            unitGroup.add(unit);
            unit.order(new None(unit));
        }
        this.observers = new ArrayList<Agent>();
    }

    public int size() {
        int result = this.observers.size();
        if (this.armyObserver != null) {
            ++result;
        }
        if (this.baseObserver != null) {
            ++result;
        }
        if (this.cwObserver != null) {
            ++result;
        }
        if (this.ccwObserver != null) {
            ++result;
        }
        return result;
    }

    public boolean done() {
        return this.size() == 0;
    }

    private Position getTarget() {
        if (!this.cwExpands.tryInitialize()) {
            return null;
        }
        if (Tyr.game.isVisible(Tyr.positionToTile(this.cwExpands.getPos()))) {
            this.cwExpands.next();
        }
        return this.cwExpands.getPos();
    }

    public static Agent getArmyObserver() {
        if (solution == null) {
            return null;
        }
        return ObserverSolution.solution.armyObserver;
    }
}

