/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import com.tyr.BWTAProxy;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.DragoonSquadSolution;
import com.tyr.tasks.Task;

public class DragoonSquadTask
extends Task {
    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        return true;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        if (!BWTAProxy.initialized) {
            return;
        }
        if (((DragoonSquadSolution)this.solution).count() == 0) {
            int dragoonCount = 0;
            boolean hasObserver = false;
            for (Agent agent : bot.homeGroup.units) {
                if (agent.unit.getType() == UnitType.Protoss_Dragoon) {
                    ++dragoonCount;
                    continue;
                }
                if (agent.unit.getType() != UnitType.Protoss_Observer) continue;
                hasObserver = true;
            }
            if (hasObserver && dragoonCount >= 8) {
                int dragoonsNeeded = 8;
                int observersNeeded = 1;
                int i = bot.homeGroup.units.size() - 1;
                while (i >= 0 && dragoonsNeeded + observersNeeded > 0) {
                    Agent agent = (Agent)bot.homeGroup.units.get(i);
                    if (agent.unit.getType() == UnitType.Protoss_Observer && observersNeeded > 0) {
                        --observersNeeded;
                        bot.homeGroup.units.remove(i);
                        ((DragoonSquadSolution)this.solution).add(agent);
                    } else if (agent.unit.getType() == UnitType.Protoss_Dragoon && dragoonsNeeded > 0) {
                        --dragoonsNeeded;
                        bot.homeGroup.units.remove(i);
                        ((DragoonSquadSolution)this.solution).add(agent);
                    }
                    --i;
                }
            }
        }
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        this.solution = new DragoonSquadSolution(this);
    }
}

