/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.Unit;
import bwta.BaseLocation;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.tasks.TargetableSolution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefendWorkerRushSolution
extends TargetableSolution {
    private List<Agent> units = new ArrayList<Agent>();
    private List<Agent> attackUnits = new ArrayList<Agent>();
    private Position target;
    private Position attackTarget;
    private Position retreatPos;
    private boolean addedToScanner = false;

    public DefendWorkerRushSolution(Task task, Position target) {
        super(task);
        this.target = target;
    }

    @Override
    public void setTarget(Position target) {
        this.target = target;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Agent agent;
        int i = this.units.size() - 1;
        while (i >= 0) {
            if (this.units.get(i).isDead()) {
                this.units.remove(i);
            }
            --i;
        }
        i = this.attackUnits.size() - 1;
        while (i >= 0) {
            if (this.attackUnits.get(i).isDead()) {
                this.attackUnits.remove(i);
            }
            --i;
        }
        i = 0;
        while (i < this.units.size()) {
            agent = this.units.get(i);
            if (agent.distanceSquared(this.target) >= 40000) {
                agent.unit.move(this.target);
            } else if (this.retreat(agent)) {
                agent.unit.move(this.getRetreatPos());
            } else {
                agent.attack(this.target);
            }
            ++i;
        }
        this.acquireTarget(bot);
        i = 0;
        while (i < this.attackUnits.size()) {
            agent = this.attackUnits.get(i);
            if (this.attackTarget == null) {
                if (agent.distanceSquared(this.target) >= 40000) {
                    agent.unit.move(this.target);
                } else {
                    agent.attack(this.target);
                }
            } else if (agent.distanceSquared(this.attackTarget) >= 40000) {
                agent.unit.move(this.attackTarget);
            } else {
                agent.attack(this.attackTarget);
            }
            ++i;
        }
    }

    private boolean retreat(Agent agent) {
        if (!Agent.isRanged(agent.unit)) {
            return false;
        }
        if (agent.unit.getGroundWeaponCooldown() > 1 && agent.unit.getAirWeaponCooldown() > 1) {
            return true;
        }
        if (agent.distanceSquared(this.getRetreatPos()) <= 10000) {
            return false;
        }
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            if (agent.distanceSquared(enemy) > 2500) continue;
            return true;
        }
        return false;
    }

    private Position getRetreatPos() {
        if (this.retreatPos == null) {
            Position start = Tyr.tileToPosition(Tyr.self.getStartLocation());
            int dist = 100000000;
            for (EnemyPosition mineral : EnemyManager.getManager().neutralBuildingMemory) {
                int newDist;
                if (!mineral.type.isMineralField() || (newDist = PositionUtil.distanceSq(mineral.pos, start)) >= dist) continue;
                dist = newDist;
                this.retreatPos = mineral.pos;
            }
        }
        return this.retreatPos;
    }

    @Override
    public void add(Agent unit) {
        if (this.units.size() < 4 || Tyr.self.getRace() == Race.Terran) {
            this.units.add(unit);
        } else {
            this.attackUnits.add(unit);
        }
    }

    @Override
    public int getCount() {
        return this.units.size() + this.attackUnits.size();
    }

    @Override
    public void done(UnitGroup unitGroup) {
        for (Agent unit : this.units) {
            unitGroup.add(unit);
            unit.order(new None(unit));
        }
        for (Agent unit : this.attackUnits) {
            unitGroup.add(unit);
            unit.order(new None(unit));
        }
        this.units = new ArrayList<Agent>();
        this.attackUnits = new ArrayList<Agent>();
    }

    public void addToScanner() {
        if (this.addedToScanner) {
            return;
        }
        this.addedToScanner = true;
        for (Agent agent : this.units) {
            Tyr.bot.scanner.add(agent);
        }
        for (Agent agent : this.attackUnits) {
            Tyr.bot.scanner.add(agent);
        }
    }

    public int distanceSq(Position target) {
        int distance = Integer.MAX_VALUE;
        for (Agent agent : this.units) {
            distance = Math.min(distance, agent.distanceSquared(target));
        }
        for (Agent agent : this.attackUnits) {
            distance = Math.min(distance, agent.distanceSquared(target));
        }
        return distance;
    }

    private boolean acquireTarget(Tyr bot) {
        if (this.attackTarget != null) {
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                if (p.pos.getX() != this.attackTarget.getX() || p.pos.getY() != this.attackTarget.getY()) continue;
                return false;
            }
        }
        Position newTarget = null;
        Iterator<Object> iterator = EnemyManager.getManager().enemyBuildingMemory.iterator();
        if (iterator.hasNext()) {
            EnemyPosition p = iterator.next();
            newTarget = p.pos;
        }
        if (newTarget == null && (iterator = bot.suspectedEnemy.iterator()).hasNext()) {
            BaseLocation b = (BaseLocation)iterator.next();
            newTarget = b.getPosition();
        }
        if (newTarget == null) {
            return false;
        }
        if (this.attackTarget == null) {
            this.attackTarget = newTarget;
            return true;
        }
        if (this.attackTarget.getX() == newTarget.getX() && this.attackTarget.getY() == newTarget.getY()) {
            return false;
        }
        this.attackTarget = newTarget;
        return true;
    }
}

