/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.IAttackGroup;
import com.tyr.unitgroups.PrioritizedAttackGroup;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class CorsairHarassSolution
extends Solution {
    private IAttackGroup attackGroup = new PrioritizedAttackGroup(this.getTarget());
    private ArrayList<Position> orderedExpands;
    private int currentPos;

    public CorsairHarassSolution(Task task) {
        super(task);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Position attackTarget = null;
        if (this.size() > 0) {
            attackTarget = this.getTarget();
        }
        if (attackTarget != null) {
            this.attackGroup.setTarget(attackTarget);
            Tyr.drawCircle(attackTarget, Color.Orange, 64);
        }
        this.attackGroup.cleanup();
        this.attackGroup.onFrame(game, self, bot);
    }

    public void add(Agent agent) {
        this.attackGroup.add(agent);
    }

    public void done(UnitGroup unitGroup) {
        for (Agent unit : this.attackGroup.units) {
            unitGroup.add(unit);
            unit.order(new None(unit));
        }
        this.attackGroup.units = new ArrayList();
    }

    public void clear() {
        this.attackGroup.clear();
    }

    public int size() {
        return this.attackGroup.units.size();
    }

    public boolean done() {
        return this.size() == 0;
    }

    private Position getTarget() {
        if (this.orderedExpands == null && Tyr.bot.suspectedEnemy.size() <= 1) {
            this.orderedExpands = (ArrayList)EnemyManager.getManager().getOrderedExpands().clone();
            if (Tyr.bot.suspectedEnemy.size() == 1) {
                this.orderedExpands.add(Tyr.bot.suspectedEnemy.get(0).getPosition());
            }
        }
        if (this.orderedExpands == null || this.orderedExpands.size() == 0) {
            return null;
        }
        if (Tyr.game.isVisible(Tyr.positionToTile(this.orderedExpands.get(this.currentPos)))) {
            this.currentPos = (this.currentPos - 1 + this.orderedExpands.size()) % this.orderedExpands.size();
        }
        return this.orderedExpands.get(this.currentPos);
    }
}

