/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.BWTAProxy;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.PositionUtil;
import com.tyr.ScannerListener;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.ConstantPushSolution;
import com.tyr.tasks.Task;
import java.util.HashSet;
import java.util.Iterator;

public class ConstantPushTask
extends Task
implements ScannerListener {
    private Position target;
    private UnitType acceptedUnit = null;
    public static HashSet<UnitType> paused = new HashSet();
    public boolean stop = false;
    private int mode;
    public static boolean prioritizeExpands = false;
    public static boolean returnForDefense = false;
    public static int reinforcementSize = 1;

    public ConstantPushTask() {
        this(0);
    }

    public ConstantPushTask(int mode) {
        Settings.addScannerListener(this);
        this.mode = mode;
    }

    public ConstantPushTask(UnitType acceptedUnit) {
        this(acceptedUnit, 0);
    }

    public ConstantPushTask(UnitType acceptedUnit, int mode) {
        Settings.addScannerListener(this);
        this.acceptedUnit = acceptedUnit;
        this.mode = mode;
    }

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        return true;
    }

    public void addToScanner() {
        if (this.solution != null) {
            ((ConstantPushSolution)this.solution).addToScanner();
        }
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        if (!BWTAProxy.initialized) {
            return;
        }
        boolean newTarget = this.acquireTarget(bot);
        if (newTarget) {
            ((ConstantPushSolution)this.solution).setTarget(this.target);
        }
        for (UnitType type : paused) {
            DebugMessages.addMessage("Push paused for: " + type.toString());
        }
        if (!this.stop && bot.homeGroup.units.size() >= reinforcementSize) {
            int i = bot.homeGroup.units.size() - 1;
            while (i >= 0) {
                Agent agent = (Agent)bot.homeGroup.units.get(i);
                if (agent.unit.getType() != UnitType.Protoss_Observer) {
                    if (paused.contains(agent.unit.getType())) {
                        agent.drawCircle(Color.White, 6);
                    } else if (this.acceptedUnit == null || agent.unit.getType() == this.acceptedUnit) {
                        ((ConstantPushSolution)this.solution).add(agent);
                        bot.homeGroup.units.remove(i);
                    }
                }
                --i;
            }
        }
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        if (BWTAProxy.initialized) {
            this.acquireTarget(bot);
        }
        this.solution = new ConstantPushSolution(this, this.target, this.mode);
    }

    public boolean acquireTarget(Tyr bot) {
        if (returnForDefense && EnemyManager.getManager().getInvaderCount() >= 4) {
            this.target = EnemyManager.getManager().getInvader().getPosition();
            return true;
        }
        if (prioritizeExpands) {
            BaseLocation enemyBase;
            boolean enemyHasExpands;
            boolean bl = enemyHasExpands = EnemyManager.getManager().getAllCount(UnitType.Protoss_Nexus) + EnemyManager.getManager().getAllCount(UnitType.Terran_Command_Center) + EnemyManager.getManager().getAllCount(UnitType.Zerg_Hatchery) + EnemyManager.getManager().getAllCount(UnitType.Zerg_Hive) + EnemyManager.getManager().getAllCount(UnitType.Zerg_Lair) >= 3;
            Position enemyNatural = Tyr.bot.suspectedEnemy.size() == 1 ? ((enemyBase = SpaceManager.getEnemyNatural()) != null ? enemyBase.getPosition() : null) : null;
            if (!enemyHasExpands && Tyr.bot.suspectedEnemy.size() == 1) {
                for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                    if (!p.type.isResourceDepot() || PositionUtil.distanceSq(Tyr.bot.suspectedEnemy.get(0).getPosition(), p.pos) <= 10000 || PositionUtil.distanceSq(enemyNatural, p.pos) <= 10000) continue;
                    enemyHasExpands = true;
                    break;
                }
            }
            if (this.target != null && enemyHasExpands && this.isNaturalOrMain(this.target, enemyNatural)) {
                this.target = null;
            }
            if (this.target != null) {
                for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                    if (!p.type.isResourceDepot() || EnemyManager.getManager().getAllCount(p.type) > 1 && bot.suspectedEnemy.size() == 1 && PositionUtil.distanceSq(p.pos, bot.suspectedEnemy.get(0).getPosition()) <= 10000 || p.pos.getX() != this.target.getX() || p.pos.getY() != this.target.getY()) continue;
                    return false;
                }
            }
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                if (!p.type.isResourceDepot() || EnemyManager.getManager().getAllCount(p.type) > 1 && bot.suspectedEnemy.size() == 1 && PositionUtil.distanceSq(p.pos, bot.suspectedEnemy.get(0).getPosition()) <= 10000 || enemyHasExpands && this.isNaturalOrMain(p.pos, enemyNatural)) continue;
                this.target = p.pos;
                return true;
            }
        }
        if (this.target != null) {
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                if (p.pos.getX() != this.target.getX() || p.pos.getY() != this.target.getY()) continue;
                return false;
            }
        }
        Position newTarget = null;
        Iterator<Object> iterator = EnemyManager.getManager().enemyBuildingMemory.iterator();
        if (iterator.hasNext()) {
            EnemyPosition p = iterator.next();
            newTarget = p.pos;
        }
        if (newTarget == null && (iterator = bot.suspectedEnemy.iterator()).hasNext()) {
            BaseLocation b = (BaseLocation)iterator.next();
            newTarget = b.getPosition();
        }
        if (newTarget == null) {
            return false;
        }
        if (this.target == null) {
            this.target = newTarget;
            return true;
        }
        if (this.target.getX() == newTarget.getX() && this.target.getY() == newTarget.getY()) {
            return false;
        }
        this.target = newTarget;
        return true;
    }

    private boolean isNaturalOrMain(Position pos, Position enemyNatural) {
        if (Tyr.bot.suspectedEnemy.size() != 1) {
            return false;
        }
        if (enemyNatural != null && PositionUtil.distanceSq(pos, enemyNatural) <= 10000) {
            return true;
        }
        return PositionUtil.distanceSq(Tyr.bot.suspectedEnemy.get(0).getPosition(), pos) <= 10000;
    }

    @Override
    public void onScannerEliminating() {
        if (this.solution != null) {
            ((ConstantPushSolution)this.solution).clear();
        }
        this.solution = null;
    }

    public void remove() {
        this.stop = true;
        if (this.solution != null) {
            ((ConstantPushSolution)this.solution).done(Tyr.bot.hobos);
        }
    }

    public void stop() {
        this.stop = true;
        this.clear();
    }

    public void go() {
        this.stop = false;
    }

    public void clear() {
        ((ConstantPushSolution)this.solution).clear();
    }

    public int size() {
        return ((ConstantPushSolution)this.solution).size();
    }
}

