/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.agents.WorkerAgent;
import com.tyr.buildingplacement.BuildCommand;
import com.tyr.buildingplacement.DefaultBuildSite;
import com.tyr.requirements.Requirement;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BuildAtLocationSolution
extends Solution {
    private Position target;
    private Agent builder;
    private List<UnitType> types = new ArrayList<UnitType>();
    private List<Requirement> requirements = new ArrayList<Requirement>();
    private BuildCommand command;
    private int next;
    private int nextUpdatedFrame = -1;
    private boolean keepExpandsFree;
    public static int buildingDistance = 500;
    public static boolean removeExcess = true;

    public BuildAtLocationSolution(Task task, Position target, List<UnitType> types, List<Requirement> requirements, boolean keepExpandsFree) {
        super(task);
        this.target = target;
        this.types = types;
        this.requirements = requirements;
        this.keepExpandsFree = keepExpandsFree;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.builder != null && this.builder.isDead()) {
            this.builder = null;
            this.command = null;
        }
        if (this.builder != null && ((WorkerAgent)this.builder).isBlocked) {
            bot.hobos.add(this.builder);
            this.builder = null;
            this.command = null;
        }
        if (this.builder != null && this.command != null && this.builder.unit.getBuildUnit() != null) {
            bot.reservedMinerals -= this.command.mineralCost();
            bot.reservedGas -= this.command.gasCost();
            this.command = null;
            this.builder.order(new None(this.builder));
            ((WorkerAgent)this.builder).blockedTimer = -1L;
            ((WorkerAgent)this.builder).isBlocked = false;
        }
        if (this.builder != null && this.command != null) {
            for (Unit unit : self.getUnits()) {
                if (unit.getTilePosition().getX() != this.command.position.getX() || unit.getTilePosition().getY() != this.command.position.getY() || unit.getType() != this.command.building) continue;
                bot.reservedMinerals -= this.command.mineralCost();
                bot.reservedGas -= this.command.gasCost();
                this.command = null;
                this.builder.order(new None(this.builder));
                ((WorkerAgent)this.builder).blockedTimer = -1L;
                ((WorkerAgent)this.builder).isBlocked = false;
                break;
            }
        }
        if (this.builder != null && this.command != null) {
            this.builder.drawCircle(Color.Blue);
            game.drawLineMap(this.command.getCenter().getX(), this.command.getCenter().getY(), this.builder.unit.getPosition().getX(), this.builder.unit.getPosition().getY(), Color.Blue);
            game.drawTextMap(this.command.worker.unit.getPosition().getX(), this.builder.unit.getPosition().getY(), this.builder.unit.getOrder().toString());
            game.drawBoxMap(this.command.position.getX() * 32, this.command.position.getY() * 32, this.command.position.getX() * 32 + 32 * this.command.building.tileWidth(), this.command.position.getY() * 32 + 32 * this.command.building.tileHeight(), Color.Orange);
            if (!(this.builder.unit.isConstructing() || !this.builder.unit.isGatheringMinerals() && (this.builder.unit.getOrder() == Order.PlaceBuilding || this.builder.unit.isMoving() && this.builder.distanceSquared(this.command.getCenter()) < 90000 && this.builder.unit.getOrder() != Order.PlayerGuard))) {
                if (game.canBuildHere(this.command.position, this.command.building, this.command.worker.unit, false)) {
                    if (this.builder.unit.getTilePosition().getDistance(this.command.position) <= 60.0) {
                        this.builder.unit.build(this.command.building, this.command.position);
                    } else {
                        this.builder.unit.move(this.command.getCenter());
                    }
                    return;
                }
                this.builder.unit.move(this.command.getCenter());
            }
        }
        this.updateNext();
        if (this.builder != null && !this.builder.unit.isConstructing() && this.needToBuild() && this.next < this.types.size()) {
            this.command = bot.spaceManager.build(this.types.get(this.next), this.target, new DefaultBuildSite(this.keepExpandsFree, this.keepExpandsFree, false, 10), this.builder);
            if (this.command == null) {
                if (removeExcess) {
                    this.types.remove(this.next);
                    --this.next;
                }
            } else if (this.types.get(this.next) == UnitType.Protoss_Pylon) {
                this.target = this.command.getCenter();
            }
        }
        if (this.command == null && this.builder != null && this.builder.distanceSquared(this.target) >= 90000) {
            this.builder.order(new None(this.builder));
            this.builder.unit.move(this.target);
        }
    }

    public boolean needToBuild() {
        this.updateNext();
        if (this.next >= this.requirements.size() || this.command != null) {
            return false;
        }
        return this.requirements.get(this.next).met();
    }

    public void setBuilder(Agent builder) {
        this.builder = builder;
    }

    public boolean needBuilder() {
        boolean needToBuild = this.needToBuild();
        return this.builder == null && needToBuild;
    }

    public void updateNext() {
        int frame = Tyr.game.getFrameCount();
        if (frame <= this.nextUpdatedFrame) {
            return;
        }
        this.nextUpdatedFrame = frame;
        HashMap<UnitType, Integer> counts = new HashMap<UnitType, Integer>();
        for (Unit unit : Tyr.self.getUnits()) {
            if (unit.getDistance(this.target) > buildingDistance) continue;
            if (!counts.containsKey(unit.getType())) {
                counts.put(unit.getType(), 0);
            }
            counts.put(unit.getType(), (Integer)counts.get(unit.getType()) + 1);
        }
        this.next = 0;
        while (this.next < this.types.size()) {
            if (!counts.containsKey(this.types.get(this.next)) || (Integer)counts.get(this.types.get(this.next)) == 0) break;
            counts.put(this.types.get(this.next), (Integer)counts.get(this.types.get(this.next)) - 1);
            ++this.next;
        }
    }

    public void clear() {
        if (this.builder != null) {
            Tyr.bot.hobos.add(this.builder);
            this.builder = null;
        }
    }

    public void addBuilding(UnitType buildingType, Requirement requirement) {
        this.types.add(buildingType);
        this.requirements.add(requirement);
    }
}

