/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import com.tyr.Force;
import com.tyr.ForceTracker;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.tasks.SolutionItem;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.AttackGroup;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class AntiLurkerSolution
extends SolutionItem
implements Force {
    private AttackGroup attackGroup;
    private Position attackTarget;
    private Position averagePos;

    public AntiLurkerSolution(Task task, Position attackTarget) {
        super(task);
        ForceTracker.register(this);
        this.attackTarget = attackTarget;
        this.attackGroup = new AttackGroup(attackTarget);
    }

    public void setTarget(Position attackTarget) {
        this.attackTarget = attackTarget;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        this.getAveragePos();
        Tyr.drawCircle(this.attackTarget, Color.Orange, 64);
        this.attackGroup.cleanup();
        this.attackGroup.setTarget(this.attackTarget);
        this.attackGroup.onFrame(game, self, bot);
    }

    @Override
    public void add(Agent agent) {
        this.attackGroup.add(agent);
    }

    public void done(UnitGroup unitGroup) {
        for (Agent unit : this.attackGroup.units) {
            unitGroup.add(unit);
            unit.order(new None(unit));
        }
        this.attackGroup.units = new ArrayList();
    }

    public void addToScanner() {
        for (Agent agent : this.attackGroup.units) {
            Tyr.bot.scanner.add(agent);
        }
        this.attackGroup.units = new ArrayList();
    }

    @Override
    public void clear() {
        this.attackGroup.clear();
    }

    @Override
    public int size() {
        return this.attackGroup.units.size();
    }

    private void getAveragePos() {
        double averageX = 0.0;
        double averageY = 0.0;
        for (Agent agent : this.attackGroup.units) {
            Position pos = agent.unit.getPosition();
            averageX += (double)pos.getX();
            averageY += (double)pos.getY();
        }
        this.averagePos = new Position((int)(averageX /= (double)this.attackGroup.units.size()), (int)(averageY /= (double)this.attackGroup.units.size()));
    }

    @Override
    public Position getCenter() {
        if (this.averagePos == null) {
            this.getAveragePos();
        }
        return this.averagePos;
    }

    @Override
    public boolean done() {
        return this.size() == 0;
    }

    @Override
    public boolean disabled() {
        return false;
    }
}

