/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.MineralWorkers;
import java.util.ArrayList;
import java.util.List;

public class AirDefenseSolution
extends Solution {
    private List<Agent> units = new ArrayList<Agent>();
    private Unit target = null;

    public AirDefenseSolution(Task task) {
        super(task);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        int i = this.units.size() - 1;
        while (i >= 0) {
            if (this.units.get(i) == null || this.units.get(i).isDead()) {
                this.units.remove(i);
            }
            --i;
        }
        if (!(this.target == null || this.target.getHitPoints() > 0 && this.target.getRemoveTimer() <= 0 && this.target.exists())) {
            Position lastSeen = EnemyManager.getManager().getLastPosition(this.target);
            if (lastSeen == null) {
                this.target = null;
            } else {
                for (Agent agent : this.units) {
                    if (agent.distanceSquared(lastSeen) > 10000) continue;
                    this.target = null;
                    break;
                }
            }
        }
        if (this.target == null) {
            for (MineralWorkers base : bot.workForce.mineralWorkers) {
                if (base.resourceDepot == null) continue;
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    if (unit.getType() != UnitType.Protoss_Reaver && unit.getType() != UnitType.Protoss_Shuttle && unit.getType() != UnitType.Protoss_High_Templar || PositionUtil.distanceSq(unit, base.resourceDepot) > 160000) continue;
                    this.target = unit;
                    break;
                }
                if (this.target != null) break;
            }
        }
        if (this.target != null) {
            Tyr.drawCircle(this.target.getPosition(), Color.Red, 16);
        }
        for (Agent agent : this.units) {
            if (!(this.target == null || this.target.getHitPoints() > 0 && this.target.getRemoveTimer() <= 0 && this.target.exists())) {
                agent.unit.move(EnemyManager.getManager().getLastPosition(this.target));
                continue;
            }
            if (this.target != null) {
                agent.attack(this.target);
                continue;
            }
            agent.unit.move(Tyr.tileToPosition(self.getStartLocation()));
        }
    }

    public void add(Agent agent) {
        this.units.add(agent);
    }

    public int size() {
        return this.units.size();
    }

    public boolean done() {
        return this.size() == 0;
    }
}

