/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitCommand;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.PositionUtil;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.builds.AntiWorkerRushProtoss;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.ConjRequirement;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.DefendMainTask;
import com.tyr.unitgroups.PrioritizedAttackGroup;

public class ZealotPush
extends CompositeBuildOrder {
    private boolean doProxy = true;
    private boolean waitForAttack = false;
    private boolean workerRush = false;
    private AntiWorkerRushProtoss antiWorkerRush = new AntiWorkerRushProtoss();
    private ConstantPushTask constantPushTask;
    private boolean cancelGateways = true;
    private boolean zealotOnly = false;

    public ZealotPush() {
        this(false, false, false);
    }

    public ZealotPush(boolean doProxy, boolean waitForAttack) {
        this.doProxy = doProxy;
        this.waitForAttack = waitForAttack;
    }

    public ZealotPush(boolean doProxy, boolean waitForAttack, boolean zealotOnly) {
        this.doProxy = doProxy;
        this.waitForAttack = waitForAttack;
        this.zealotOnly = zealotOnly;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(7);
        Settings.setWorkersPerGas(2);
        this.add(new WorkerScoutPart(1600));
        this.add(new ExpandPart(true));
        PrioritizedAttackGroup.allowRetreat = true;
        if (this.doProxy) {
            Position proxy = this.getProxyPosition();
            BuildAtLocationTask buildTask = new BuildAtLocationTask(proxy, false);
            buildTask.addBuilding(UnitType.Protoss_Pylon, new UnitRequirement(UnitType.Protoss_Probe, 7));
            buildTask.addBuilding(UnitType.Protoss_Gateway, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Pylon, 1, true)).addRequirement(new CostRequirement(250, 0)));
            buildTask.addBuilding(UnitType.Protoss_Gateway, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Gateway)).addRequirement(new CostRequirement(100, 0)));
            buildTask.addBuilding(UnitType.Protoss_Gateway, new CostRequirement(300, 0));
            buildTask.addBuilding(UnitType.Protoss_Gateway, new CostRequirement(250, 0));
            buildTask.addBuilding(UnitType.Protoss_Gateway, new CostRequirement(250, 0));
            bot.taskManager.potentialTasks.add(buildTask);
        }
        Attack.requiredAtCannon = 0;
        if (!this.waitForAttack) {
            this.constantPushTask = new ConstantPushTask(null, 1);
            bot.taskManager.potentialTasks.add(this.constantPushTask);
        }
        super.initialize(game, self, bot);
    }

    private Position getProxyPosition() {
        Game game = Tyr.game;
        int width = 20;
        int height = 20;
        int powerRange = 8;
        Position best = new Position(game.mapWidth() * 16, game.mapHeight() * 16);
        int power = 0;
        int dist = 0;
        int posX = game.mapWidth() / 2 - width / 2;
        while (posX <= game.mapWidth() / 2 + width / 2) {
            int posY = game.mapHeight() / 2 - height / 2;
            while (posY <= game.mapHeight() / 2 + height / 2) {
                int newDist = Math.abs(game.mapWidth() / 2 - posX) + Math.abs(game.mapHeight() / 2 - posY);
                int newPower = 0;
                int checkX = -powerRange;
                while (checkX <= powerRange) {
                    int checkY = -powerRange;
                    while (checkY <= powerRange) {
                        if (game.isBuildable(new TilePosition(posX + checkX, posY + checkY))) {
                            ++newPower;
                        }
                        ++checkY;
                    }
                    ++checkX;
                }
                if (newPower > power || newPower == power && newDist < dist) {
                    power = newPower;
                    dist = newDist;
                    best = new Position(posX * 32, posY * 32);
                }
                ++posY;
            }
            ++posX;
        }
        System.out.println("Best power found: " + power);
        return best;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (!this.workerRush && EnemyManager.getManager().getAllCount(MARINE) < 5) {
            int count = 0;
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (!unit.getType().isWorker() || PositionUtil.distanceSq(unit, Tyr.tileToPosition(self.getStartLocation())) > Settings.getLargeInvasionDist() * Settings.getLargeInvasionDist()) continue;
                ++count;
            }
            if (count >= 3) {
                this.workerRush = true;
                this.antiWorkerRush.initialize(game, self, bot);
            }
        }
        if (EnemyManager.getManager().getAllCount(MARINE) >= 5) {
            this.workerRush = false;
            this.constantPushTask.stop = false;
            DefendMainTask.workerRush = false;
        }
        if (this.workerRush) {
            DebugMessages.addMessage("Countering worker rush.");
            if (UnitTracker.count(UnitType.Protoss_Gateway) < 4 && bot.getAvailableMinerals() >= 350) {
                this.cancelGateways = false;
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
            Settings.setClearMinerals(false);
            if (this.constantPushTask != null) {
                this.constantPushTask.stop = true;
            }
            if (this.cancelGateways && UnitTracker.count(UnitType.Protoss_Gateway) > 1 && self.completedUnitCount(UnitType.Protoss_Gateway) < UnitTracker.count(UnitType.Protoss_Gateway) && game.getFrameCount() % 5 == 0) {
                for (Unit unit : self.getUnits()) {
                    if (unit.getType() != UnitType.Protoss_Gateway || unit.isCompleted()) continue;
                    Tyr.drawCircle(unit.getPosition(), Color.Purple, 6);
                    unit.issueCommand(UnitCommand.cancelConstruction(unit));
                    unit.cancelConstruction();
                    break;
                }
            }
            this.antiWorkerRush.onFrame(game, self, bot);
            return;
        }
        DebugMessages.addMessage("Performing zealot rush.");
        super.onFrame(game, self, bot);
        if (this.waitForAttack && self.completedUnitCount(UnitType.Protoss_Zealot) >= 10) {
            this.waitForAttack = false;
            this.constantPushTask = new ConstantPushTask(null, 1);
            bot.taskManager.potentialTasks.add(this.constantPushTask);
        }
        if (UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0) {
            Settings.setMaximumWorkers(30);
        } else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 4) {
            Settings.setMaximumWorkers(25);
        } else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 2) {
            Settings.setMaximumWorkers(9);
        }
        if (UnitTracker.count(UnitType.Protoss_Zealot) >= 2 && UnitTracker.count(UnitType.Protoss_Gateway) < 4) {
            Settings.setMaximumWorkers(20);
        }
        if (!this.doProxy) {
            if (UnitTracker.count(UnitType.Protoss_Probe) >= 7 && UnitTracker.count(UnitType.Protoss_Pylon) == 0 && bot.getAvailableMinerals() >= 100) {
                bot.spaceManager.build(UnitType.Protoss_Pylon);
            }
            if (self.completedUnitCount(UnitType.Protoss_Pylon) > 0 && bot.getAvailableMinerals() >= 250 && UnitTracker.count(UnitType.Protoss_Gateway) == 0) {
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
            if (UnitTracker.count(UnitType.Protoss_Gateway) == 1 && bot.getAvailableMinerals() >= 100) {
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
            if (UnitTracker.count(UnitType.Protoss_Gateway) == 2 && bot.getAvailableMinerals() >= 300) {
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
            if (UnitTracker.count(UnitType.Protoss_Gateway) >= 3 && UnitTracker.count(UnitType.Protoss_Gateway) < 4 && bot.getAvailableMinerals() >= 250) {
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Protoss_Gateway) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400 && UnitTracker.count(UnitType.Protoss_Pylon) >= 1 && (UnitTracker.count(UnitType.Protoss_Zealot) >= 2 || self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() < 4)) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (!(UnitTracker.count(UnitType.Protoss_Assimilator) >= 2 || bot.getAvailableMinerals() < 100 || UnitTracker.getGeyserCount() <= 0 || UnitTracker.count(UnitType.Protoss_Probe) < 25 && bot.getAvailableMinerals() < 300 || this.zealotOnly)) {
            bot.spaceManager.build(UnitType.Protoss_Assimilator);
        }
        if (!(bot.getAvailableMinerals() < 200 || UnitTracker.count(UnitType.Protoss_Cybernetics_Core) >= 1 || UnitTracker.count(UnitType.Protoss_Probe) < 25 && bot.getAvailableMinerals() < 300 || this.zealotOnly)) {
            bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
        }
        if (bot.getAvailableMinerals() >= 300 && UnitTracker.count(UnitType.Protoss_Nexus) >= 2 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Forge) == 0) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (UnitTracker.count(UnitType.Protoss_Gateway) < 7 && UnitTracker.count(UnitType.Protoss_Gateway) >= 4 && bot.getAvailableMinerals() >= 300 && UnitTracker.count(UnitType.Protoss_Nexus) >= 2 && UnitTracker.count(UnitType.Protoss_Forge) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (this.workerRush) {
            return this.antiWorkerRush.overrideStructureOrder(game, self, bot, agent);
        }
        if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining()) {
            if ((UnitTracker.count(UnitType.Protoss_Zealot) <= UnitTracker.count(UnitType.Protoss_Dragoon) || self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) == 0) && bot.getAvailableMinerals() >= 100) {
                agent.unit.build(UnitType.Protoss_Zealot);
            } else if (UnitTracker.count(UnitType.Protoss_Zealot) > UnitTracker.count(UnitType.Protoss_Dragoon) && bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                agent.unit.build(UnitType.Protoss_Dragoon);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Singularity_Charge.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Singularity_Charge.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        }
        return false;
    }
}

