/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.tasks.AssignScience;
import com.tyr.tasks.LayMinesTask;
import com.tyr.tasks.VultureHarassTask;

public class TwoBaseMech
extends CompositeBuildOrder {
    private boolean coreExists = false;
    private boolean dtSeen = false;
    private boolean vultureHarassStarted = false;
    private boolean vesselSupport = true;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(40);
        Settings.setMaximumSize(60);
        bot.bunkers.maximumRepair = 1;
        bot.taskManager.potentialTasks.add(new LayMinesTask());
        bot.taskManager.potentialTasks.add(new AssignScience());
        this.add(new WorkerScoutPart(1800));
        this.add(new ExpandPart());
        ExpandPart.maximumCcs = 2;
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        int count;
        super.onFrame(game, self, bot);
        if (!this.dtSeen) {
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType() != UnitType.Protoss_Dark_Templar) continue;
                this.dtSeen = true;
                break;
            }
        }
        Settings.setBlockAttack(this.dtSeen && UnitTracker.count(UnitType.Terran_Science_Vessel) == 0);
        if (!this.coreExists) {
            if (this.dtSeen) {
                this.coreExists = true;
            }
            for (EnemyPosition building : EnemyManager.getManager().enemyBuildingMemory) {
                if (building.type != UnitType.Protoss_Cybernetics_Core && building.type != UnitType.Protoss_Templar_Archives && building.type != UnitType.Protoss_Citadel_of_Adun && building.type != UnitType.Protoss_Assimilator) continue;
                this.coreExists = true;
                break;
            }
        }
        if (this.coreExists) {
            DebugMessages.addMessage("DTs incoming.");
            if (bot.getAvailableMinerals() >= 125 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 1 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
                bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
            }
        }
        if (!this.vultureHarassStarted && bot.homeGroup.units.size() >= 20) {
            this.vultureHarassStarted = true;
            bot.taskManager.potentialTasks.add(new VultureHarassTask());
        }
        DebugMessages.addMessage("Going Mech.");
        if (UnitTracker.count(UnitType.Terran_Factory) < 1 && (bot.getAvailableGas() >= 100 || bot.getAvailableMinerals() < 100)) {
            Settings.setWorkersPerGas(1);
        } else if (bot.getAvailableGas() >= 300 || UnitTracker.count(UnitType.Terran_Factory) <= 2 && bot.getAvailableGas() >= 100) {
            Settings.setWorkersPerGas(2);
        } else {
            Settings.setWorkersPerGas(3);
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Terran_Barracks) * 3 + UnitTracker.count(UnitType.Terran_Starport) * 3 + UnitTracker.count(UnitType.Terran_Factory) * 4 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(UnitType.Terran_Supply_Depot);
        }
        if (bot.homeGroup.units.size() >= 30) {
            ExpandPart.maximumCcs = 100;
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) < 1 && UnitTracker.count(UnitType.Terran_Command_Center) >= 2) {
            bot.spaceManager.build(UnitType.Terran_Barracks);
        }
        if (UnitTracker.count(UnitType.Terran_Refinery) < UnitTracker.count(UnitType.Terran_Command_Center) && (UnitTracker.count(UnitType.Terran_Refinery) == 0 || self.completedUnitCount(UnitType.Terran_Factory) >= 2) && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if (bot.getAvailableMinerals() >= 125 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 1 && UnitTracker.count(UnitType.Terran_Factory) >= 2) {
            bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0 && UnitTracker.count(UnitType.Terran_Academy) == 0 && UnitTracker.count(UnitType.Terran_Factory) >= 2) {
            bot.spaceManager.build(UnitType.Terran_Academy);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                if (structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) < 128.0 && (UnitTracker.count(UnitType.Terran_Factory) == 0 || UnitTracker.getCcCount() >= 2) || (count = structures.getUnitCount(UnitType.Terran_Bunker)) >= 1) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if (bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.getCcCount() >= 2 && UnitTracker.count(UnitType.Terran_Factory) < 7 && (UnitTracker.count(UnitType.Terran_Factory) < 2 * UnitTracker.getCcCount() - 1 || bot.getAvailableMinerals() >= 500) && (UnitTracker.count(UnitType.Terran_Factory) == 0 || bot.getAvailableMinerals() >= 250 && bot.getAvailableGas() >= 150)) {
            bot.spaceManager.build(UnitType.Terran_Factory);
        }
        if (UnitTracker.count(UnitType.Terran_Engineering_Bay) >= 1 && bot.getAvailableMinerals() >= 75) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                count = structures.getUnitCount(UnitType.Terran_Missile_Turret);
                if (count != 0 || structures.defences.size() <= 0) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Missile_Turret, structures);
                break;
            }
        }
        if (UnitTracker.count(UnitType.Terran_Starport) >= 1 && UnitTracker.count(UnitType.Terran_Armory) < 2 && bot.getAvailableGas() >= 50 && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Terran_Armory);
        }
        if (UnitTracker.count(UnitType.Terran_Factory) >= 3 && this.vesselSupport && bot.homeGroup.units.size() >= 20 && UnitTracker.count(UnitType.Terran_Starport) == 0 && bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 150) {
            bot.spaceManager.build(UnitType.Terran_Starport);
        }
        if (UnitTracker.count(UnitType.Terran_Factory) >= 3 && this.vesselSupport && UnitTracker.count(UnitType.Terran_Science_Facility) < 1 && bot.homeGroup.units.size() >= 20 && self.completedUnitCount(UnitType.Terran_Starport) > 0 && bot.getAvailableGas() >= 150 && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Terran_Science_Facility);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            if (!(agent.unit.isTraining() || bot.getAvailableMinerals() < 50 || UnitTracker.count(UnitType.Terran_Marine) >= 8 && bot.getAvailableMinerals() < 500)) {
                agent.unit.train(UnitType.Terran_Marine);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Factory) {
            boolean addonWanted;
            if (agent.unit.getAddon() != null) {
                return false;
            }
            boolean bl = addonWanted = UnitTracker.usableAddOns(UnitType.Terran_Machine_Shop) * 3 + 1 < self.completedUnitCount(UnitType.Terran_Factory) || self.completedUnitCount(UnitType.Terran_Factory) <= 1;
            if (UnitTracker.count(UnitType.Terran_Armory) >= 1 && !agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 5 + UnitTracker.count(UnitType.Terran_Goliath) * 2 && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 50) {
                agent.unit.train(UnitType.Terran_Goliath);
                return true;
            }
            if (!(bot.getAvailableMinerals() < 75 || agent.unit.isTraining() || UnitTracker.count(UnitType.Terran_Vulture) > 4 + 2 * (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode)) && bot.getAvailableMinerals() < 500 && addonWanted)) {
                agent.unit.train(UnitType.Terran_Vulture);
                return true;
            }
            return !addonWanted;
        }
        if (agent.unit.getType() == UnitType.Terran_Machine_Shop) {
            if (!agent.unit.isResearching() && self.hasResearched(TechType.Tank_Siege_Mode) && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100) {
                agent.unit.research(TechType.Spider_Mines);
            }
        } else {
            if (agent.unit.getType() == UnitType.Terran_Starport) {
                if (this.vesselSupport && agent.unit.getAddon() == null && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                    agent.unit.buildAddon(UnitType.Terran_Control_Tower);
                }
                if (this.vesselSupport && !agent.unit.isTraining() && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 225 && UnitTracker.count(UnitType.Terran_Science_Vessel) < 2) {
                    agent.unit.train(UnitType.Terran_Science_Vessel);
                }
                return true;
            }
            if (agent.unit.getType() == UnitType.Terran_Science_Facility) {
                return true;
            }
            if (agent.unit.getType() == UnitType.Terran_Engineering_Bay) {
                return true;
            }
            if (agent.unit.getType() == UnitType.Terran_Armory) {
                if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Weapons.gasPrice()) {
                    agent.unit.upgrade(UpgradeType.Terran_Vehicle_Weapons);
                }
                if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Plating.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Plating.gasPrice()) {
                    agent.unit.upgrade(UpgradeType.Terran_Vehicle_Plating);
                }
                return true;
            }
        }
        return false;
    }
}

