/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.ForceTracker;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.tasks.DropHarassTask;
import com.tyr.tasks.LayMinesTask;

public class OneBaseMech
extends CompositeBuildOrder {
    boolean scoutRequested = false;
    boolean coreExists = false;
    boolean isExpanding = false;
    boolean enemyExpanding = false;
    boolean wraiths = false;
    boolean drops = true;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(50);
        Settings.setMaximumSize(60);
        bot.taskManager.potentialTasks.add(new LayMinesTask());
        bot.taskManager.potentialTasks.add(new DropHarassTask());
        this.isExpanding = true;
        ExpandPart.maximumCcs = 2;
        this.add(new ExpandPart(true));
        this.add(new WorkerScoutPart(1800));
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        super.onFrame(game, self, bot);
        if (!this.coreExists) {
            for (EnemyPosition building : EnemyManager.getManager().enemyBuildingMemory) {
                if (building.type != UnitType.Protoss_Cybernetics_Core && building.type != UnitType.Protoss_Templar_Archives && building.type != UnitType.Protoss_Citadel_of_Adun && building.type != UnitType.Protoss_Assimilator) continue;
                this.coreExists = true;
                break;
            }
        }
        if (!this.enemyExpanding) {
            int enemyBaseCount = 0;
            for (EnemyPosition building : EnemyManager.getManager().enemyBuildingMemory) {
                if (!building.type.isResourceDepot() || ++enemyBaseCount < 2) continue;
                this.enemyExpanding = true;
                break;
            }
        }
        if (this.coreExists) {
            DebugMessages.addMessage("DTs incoming.");
            if (bot.getAvailableMinerals() >= 125 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 1 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
                bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
            }
        }
        DebugMessages.addMessage("Going Mech.");
        if (UnitTracker.count(UnitType.Terran_Factory) < 1 && (bot.getAvailableGas() >= 100 || bot.getAvailableMinerals() < 100)) {
            Settings.setWorkersPerGas(1);
        } else if (!(UnitTracker.count(UnitType.Terran_Factory) > 2 && bot.getAvailableGas() < 200 || bot.getAvailableGas() < 100 && bot.getAvailableMinerals() >= 150)) {
            Settings.setWorkersPerGas(2);
        } else {
            Settings.setWorkersPerGas(3);
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Terran_Barracks) * 4 + UnitTracker.count(UnitType.Terran_Starport) * 4 + UnitTracker.count(UnitType.Terran_Factory) * 5 + UnitTracker.getCcCount() * 4 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(UnitType.Terran_Supply_Depot);
        }
        if (bot.homeGroup.units.size() >= 15 && !this.isExpanding || this.enemyExpanding) {
            this.isExpanding = true;
            ExpandPart.maximumCcs = 2;
            this.add(new ExpandPart());
        }
        if (this.isExpanding && ExpandPart.maximumCcs == 2 && (bot.homeGroup.units.size() >= 45 || ForceTracker.forces.size() >= 3)) {
            ExpandPart.maximumCcs = 100;
        }
        if (!(bot.getAvailableMinerals() < 150 || UnitTracker.count(UnitType.Terran_Barracks) >= 1 || this.isExpanding && UnitTracker.getCcCount() <= 1)) {
            bot.spaceManager.build(UnitType.Terran_Barracks);
        }
        if (UnitTracker.count(UnitType.Terran_Refinery) < UnitTracker.count(UnitType.Terran_Command_Center) && (UnitTracker.count(UnitType.Terran_Refinery) == 0 || UnitTracker.count(UnitType.Terran_Factory) >= 2 || UnitTracker.count(UnitType.Terran_Starport) > 0) && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if (bot.getAvailableMinerals() >= 125 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 1 && UnitTracker.count(UnitType.Terran_Factory) >= 2) {
            bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0 && UnitTracker.count(UnitType.Terran_Academy) == 0 && UnitTracker.count(UnitType.Terran_Factory) >= 2) {
            bot.spaceManager.build(UnitType.Terran_Academy);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                int count;
                if (structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) < 128.0 && (UnitTracker.count(UnitType.Terran_Factory) == 0 || UnitTracker.getCcCount() >= 2) || (count = structures.getUnitCount(UnitType.Terran_Bunker)) >= 1) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if (!(bot.getAvailableMinerals() < 200 || bot.getAvailableGas() < 100 || UnitTracker.count(UnitType.Terran_Barracks) < 1 || UnitTracker.count(UnitType.Terran_Factory) >= 8 || UnitTracker.count(UnitType.Terran_Factory) >= 1 && bot.getAvailableGas() <= 150 || UnitTracker.count(UnitType.Terran_Factory) >= 4 && UnitTracker.count(UnitType.Terran_Starport) <= 0 && (this.wraiths || this.drops) || UnitTracker.count(UnitType.Terran_Factory) >= 3 * UnitTracker.getCcCount() - 1 || UnitTracker.count(UnitType.Terran_Factory) >= 2 && bot.getAvailableGas() < 200 || this.isExpanding && UnitTracker.getCcCount() <= 1)) {
            bot.spaceManager.build(UnitType.Terran_Factory);
        }
        if ((this.wraiths || this.drops) && UnitTracker.count(UnitType.Terran_Factory) >= 4 && UnitTracker.count(UnitType.Terran_Starport) == 0 && bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 150) {
            bot.spaceManager.build(UnitType.Terran_Starport);
        }
        if (UnitTracker.count(UnitType.Terran_Engineering_Bay) >= 1 && bot.getAvailableMinerals() >= 75) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                int count = structures.getUnitCount(UnitType.Terran_Missile_Turret);
                if (count != 0 || structures.defences.size() <= 0) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Missile_Turret, structures);
                break;
            }
        }
        if (UnitTracker.count(UnitType.Terran_Factory) >= 5 && UnitTracker.getCcCount() >= 3 && UnitTracker.count(UnitType.Terran_Armory) < 2 && bot.getAvailableGas() >= 50 && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Terran_Armory);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            if (!(agent.unit.isTraining() || bot.getAvailableMinerals() < 50 || UnitTracker.count(UnitType.Terran_Marine) >= 8 && bot.getAvailableMinerals() < 350 || this.isExpanding && UnitTracker.getCcCount() <= 1)) {
                agent.unit.train(UnitType.Terran_Marine);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Starport) {
            if ((this.wraiths || this.drops) && !agent.unit.isTraining() && agent.unit.getAddon() == null && (UnitTracker.count(UnitType.Terran_Wraith) > 0 || this.drops) && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                agent.unit.buildAddon(UnitType.Terran_Control_Tower);
                return true;
            }
            if (this.drops && !agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_Dropship) == 0 && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100 && agent.unit.getAddon() != null) {
                agent.unit.train(UnitType.Terran_Dropship);
                return true;
            }
            if (!this.wraiths) {
                return true;
            }
        } else if (agent.unit.getType() == UnitType.Terran_Control_Tower) {
            if (this.wraiths && !self.hasResearched(TechType.Cloaking_Field) && !self.isResearching(TechType.Cloaking_Field) && bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 150) {
                agent.unit.research(TechType.Cloaking_Field);
                return true;
            }
        } else {
            if (agent.unit.getType() == UnitType.Terran_Factory) {
                boolean addonWanted;
                if (this.isExpanding && UnitTracker.getCcCount() <= 1) {
                    return true;
                }
                if (agent.unit.getAddon() != null) {
                    return false;
                }
                boolean bl = addonWanted = UnitTracker.usableAddOns(UnitType.Terran_Machine_Shop) * 3 + 1 < self.completedUnitCount(UnitType.Terran_Factory) || self.completedUnitCount(UnitType.Terran_Factory) <= 1;
                if (UnitTracker.count(UnitType.Terran_Armory) >= 1 && !agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 5 + UnitTracker.count(UnitType.Terran_Goliath) / 2 && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 50) {
                    agent.unit.train(UnitType.Terran_Goliath);
                    return true;
                }
                if (!(bot.getAvailableMinerals() < 75 || agent.unit.isTraining() || UnitTracker.count(UnitType.Terran_Vulture) > (this.enemyExpanding ? 0 : 4) + 2 * (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode)) && bot.getAvailableMinerals() < 500 && addonWanted)) {
                    agent.unit.train(UnitType.Terran_Vulture);
                    return true;
                }
                if (UnitTracker.count(UnitType.Terran_Vulture) <= 4) {
                    return true;
                }
                return !addonWanted;
            }
            if (agent.unit.getType() == UnitType.Terran_Machine_Shop) {
                if (!(agent.unit.isResearching() || self.hasResearched(TechType.Spider_Mines) || self.isResearching(TechType.Spider_Mines) || bot.getAvailableMinerals() < 100 || bot.getAvailableGas() < 100)) {
                    agent.unit.research(TechType.Spider_Mines);
                    return true;
                }
            } else if (agent.unit.getType() == UnitType.Terran_Science_Facility) {
                if (!agent.unit.isResearching() && agent.unit.getAddon() == null && bot.getAvailableGas() >= 50 && bot.getAvailableMinerals() >= 50) {
                    agent.unit.buildAddon(UnitType.Terran_Physics_Lab);
                }
            } else {
                if (agent.unit.getType() == UnitType.Terran_Engineering_Bay) {
                    return true;
                }
                if (agent.unit.getType() == UnitType.Terran_Physics_Lab) {
                    if (!agent.unit.isResearching() && !agent.unit.isUpgrading() && bot.getAvailableGas() >= 150 && bot.getAvailableMinerals() >= 150) {
                        agent.unit.upgrade(UpgradeType.Colossus_Reactor);
                    } else if (!agent.unit.isResearching() && !agent.unit.isUpgrading() && bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 100) {
                        agent.unit.research(TechType.Yamato_Gun);
                    }
                    return true;
                }
                if (agent.unit.getType() == UnitType.Terran_Armory) {
                    if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Weapons.gasPrice()) {
                        agent.unit.upgrade(UpgradeType.Terran_Vehicle_Weapons);
                    }
                    if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Plating.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Plating.gasPrice()) {
                        agent.unit.upgrade(UpgradeType.Terran_Vehicle_Plating);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

