/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.tasks.ConstantPushTask;

public class MassReaver
extends CompositeBuildOrder {
    boolean defensesInitialized = false;
    boolean sendDragoons = false;
    boolean sendReavers = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(40);
        Settings.setSmallInvasionDist(480);
        Settings.setLargeInvasionDist(768);
        Settings.setWorkersPerGas(3);
        Attack.dontWaitAtCannon = true;
        this.add(new ExpandPart(true));
        this.add(new WorkerScoutPart(1600));
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        super.onFrame(game, self, bot);
        int n = ExpandPart.maximumCcs = MassReaver.count(REAVER) > 0 ? 2 : 1;
        if (!this.sendDragoons && self.completedUnitCount(UnitType.Protoss_Dragoon) >= 10) {
            this.sendDragoons = true;
            bot.taskManager.potentialTasks.add(new ConstantPushTask());
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Protoss_Gateway) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Protoss_Gateway) == 0 && self.completedUnitCount(UnitType.Protoss_Pylon) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Protoss_Gateway) < 4 && UnitTracker.count(UnitType.Protoss_Gateway) > 0 && UnitTracker.count(NEXUS) > 1 && MassReaver.count(REAVER) >= 3) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (UnitTracker.count(UnitType.Protoss_Assimilator) < 2 && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Protoss_Gateway) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Assimilator);
        }
        if (bot.getAvailableMinerals() >= 200 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1 && self.completedUnitCount(UnitType.Protoss_Gateway) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
        }
        if (bot.getAvailableGas() >= 200 && bot.getAvailableMinerals() >= 200 && MassReaver.completed(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Robotics_Facility) == 0) {
            bot.spaceManager.build(UnitType.Protoss_Robotics_Facility);
        }
        if (bot.getAvailableGas() >= 200 && bot.getAvailableMinerals() >= 200 && MassReaver.completed(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Robotics_Facility) == 1 && MassReaver.count(ROBO_SUPPORT) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Robotics_Facility);
        }
        if (bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 150 && self.completedUnitCount(UnitType.Protoss_Robotics_Facility) > 0 && UnitTracker.count(UnitType.Protoss_Robotics_Support_Bay) == 0) {
            bot.spaceManager.build(UnitType.Protoss_Robotics_Support_Bay);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining()) {
            if (MassReaver.count(ZEALOT) < 3 && MassReaver.minerals() >= 100) {
                agent.unit.build(ZEALOT);
            }
            if (UnitTracker.count(UnitType.Protoss_Reaver) < 2 && (MassReaver.minerals() <= 300 || MassReaver.gas() <= 200)) {
                return true;
            }
            if (UnitTracker.count(UnitType.Protoss_Reaver) >= 3 && MassReaver.minerals() >= 125 && MassReaver.gas() >= 50) {
                agent.unit.build(UnitType.Protoss_Dragoon);
            } else if (bot.getAvailableMinerals() >= 250 && bot.getAvailableGas() >= 50) {
                agent.unit.build(UnitType.Protoss_Dragoon);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Singularity_Charge.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Singularity_Charge.gasPrice() && UnitTracker.count(UnitType.Protoss_Reaver) >= 2) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Robotics_Facility) {
            if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100 && MassReaver.count(REAVER) < 4) {
                agent.unit.build(UnitType.Protoss_Reaver);
            }
            return true;
        }
        return false;
    }
}

