/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ConstantPushTask;

public class FiveGate
extends CompositeBuildOrder {
    boolean attackStarted = false;
    private ConstantPushTask constantPushTask;
    private boolean detectionNeeded = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(40);
        Attack.dontWaitAtCannon = true;
        this.add(new ExpandPart(true));
        ExpandPart.maximumCcs = 2;
        this.add(new WorkerScoutPart(1600));
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        super.onFrame(game, self, bot);
        if (UnitTracker.count(UnitType.Protoss_Gateway) >= 3) {
            Settings.setWorkersPerGas(3);
        }
        if (EnemyManager.getManager().getEnemyTypes().contains(UnitType.Protoss_Dark_Templar) || EnemyManager.getManager().getEnemyTypes().contains(UnitType.Zerg_Lurker)) {
            this.detectionNeeded = true;
        }
        if (!this.attackStarted && bot.homeGroup.units.size() >= 20) {
            this.attackStarted = true;
            this.constantPushTask = new ConstantPushTask(null);
            bot.taskManager.potentialTasks.add(this.constantPushTask);
            ExpandPart.maximumCcs = 100;
            BuildAtLocationTask.stop = true;
        }
        if (this.attackStarted) {
            DebugMessages.addMessage("Attacking!");
        }
        if (this.constantPushTask != null && self.completedUnitCount(UnitType.Protoss_Zealot) + self.completedUnitCount(UnitType.Protoss_Dragoon) <= 10) {
            this.constantPushTask.stop = true;
        }
        if (this.constantPushTask != null && self.completedUnitCount(UnitType.Protoss_Zealot) + self.completedUnitCount(UnitType.Protoss_Dragoon) >= 20) {
            this.constantPushTask.stop = false;
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Protoss_Gateway) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400 && UnitTracker.count(UnitType.Protoss_Nexus) >= 2) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Protoss_Gateway) < 2 && UnitTracker.count(UnitType.Protoss_Nexus) >= 2) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (bot.getAvailableMinerals() >= 250 && UnitTracker.count(UnitType.Protoss_Gateway) < 5 && UnitTracker.count(UnitType.Protoss_Nexus) >= 2) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (UnitTracker.count(UnitType.Protoss_Nexus) >= 2 && bot.getAvailableMinerals() >= 500 && UnitTracker.count(UnitType.Protoss_Gateway) < 7) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (UnitTracker.count(UnitType.Protoss_Assimilator) < 2 && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Protoss_Gateway) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Assimilator);
        }
        if (bot.getAvailableMinerals() >= 200 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1 && self.completedUnitCount(UnitType.Protoss_Gateway) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining()) {
            if (this.detectionNeeded && UnitTracker.count(UnitType.Protoss_Observer) == 0 && (bot.getAvailableMinerals() <= 325 || bot.getAvailableGas() <= 150)) {
                return true;
            }
            if ((UnitTracker.count(UnitType.Protoss_Zealot) <= UnitTracker.count(UnitType.Protoss_Dragoon) || self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) == 0) && bot.getAvailableMinerals() >= 100) {
                agent.unit.build(UnitType.Protoss_Zealot);
            } else if (UnitTracker.count(UnitType.Protoss_Zealot) > UnitTracker.count(UnitType.Protoss_Dragoon) && bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                agent.unit.build(UnitType.Protoss_Dragoon);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Singularity_Charge.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Singularity_Charge.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Robotics_Facility && UnitTracker.count(UnitType.Protoss_Observer) <= 2 && bot.getAvailableMinerals() >= 25 && bot.getAvailableGas() >= 75 && !agent.unit.isTraining()) {
            agent.unit.build(UnitType.Protoss_Observer);
        }
        return false;
    }
}

