/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.DefendMainTask;

public class FakeDT
extends CompositeBuildOrder {
    private ConstantPushTask constantPushTask;
    private boolean transition;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(20);
        Settings.setLargeInvasionDist(768);
        this.add(new WorkerScoutPart(1600));
        this.constantPushTask = new ConstantPushTask(UnitType.Protoss_Dark_Templar, 1);
        bot.taskManager.potentialTasks.add(this.constantPushTask);
        Attack.dontWaitAtCannon = true;
        DefendMainTask.keepZealotsBack = true;
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        super.onFrame(game, self, bot);
        Settings.setWorkersPerGas(3);
        if (!this.transition && FakeDT.completed(DARK_TEMPLAR) > 0) {
            this.transition = true;
            this.constantPushTask.stop = true;
            Settings.setMaximumWorkers(40);
            this.constantPushTask = new ConstantPushTask(null, 3);
            this.constantPushTask.stop = true;
            bot.taskManager.potentialTasks.add(this.constantPushTask);
        }
        if (this.transition) {
            if (FakeDT.armySize() <= 10) {
                this.constantPushTask.stop = true;
            }
            if (FakeDT.armySize() >= 15) {
                this.constantPushTask.stop = false;
            }
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Protoss_Gateway) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (!(bot.getAvailableMinerals() < 150 || UnitTracker.count(UnitType.Protoss_Gateway) >= 1 && bot.getAvailableMinerals() < 300 || UnitTracker.count(UnitType.Protoss_Gateway) >= 2 && !this.transition || UnitTracker.count(UnitType.Protoss_Gateway) >= 4)) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (bot.getAvailableMinerals() >= 250 && this.transition && UnitTracker.count(UnitType.Protoss_Gateway) >= 4 && UnitTracker.count(UnitType.Protoss_Gateway) < 7) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Protoss_Forge) == 0 && this.transition && FakeDT.completed(DRAGOON) + FakeDT.completed(ZEALOT) >= 20) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (UnitTracker.count(UnitType.Protoss_Assimilator) < 2 && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Protoss_Gateway) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Assimilator);
        }
        if (bot.getAvailableMinerals() >= 200 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1 && self.completedUnitCount(UnitType.Protoss_Gateway) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
        }
        if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Protoss_Citadel_of_Adun) < 1 && self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Citadel_of_Adun);
        }
        if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 200 && UnitTracker.count(UnitType.Protoss_Templar_Archives) < 1 && self.completedUnitCount(UnitType.Protoss_Citadel_of_Adun) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Templar_Archives);
        }
        if (FakeDT.gas() >= 200 && FakeDT.minerals() >= 200 && FakeDT.count(ROBOTICS_FACILITY) < 1 && FakeDT.count(GATEWAY) >= 2 && FakeDT.armySize() >= 2) {
            bot.spaceManager.build(ROBOTICS_FACILITY);
        }
        if (FakeDT.gas() >= 50 && FakeDT.minerals() >= 100 && FakeDT.completed(ROBOTICS_FACILITY) > 0 && FakeDT.count(OBSERVATORY) == 0) {
            bot.spaceManager.build(OBSERVATORY);
        }
    }

    private static int armySize() {
        return FakeDT.completed(ZEALOT) + FakeDT.completed(DRAGOON) + FakeDT.completed(DARK_TEMPLAR);
    }

    private boolean pauseProduction() {
        if (FakeDT.armySize() >= 2 && FakeDT.count(GATEWAY) > 2 && FakeDT.completed(CYBERNETICS_CORE) > 0 && FakeDT.count(ROBOTICS_FACILITY) == 0) {
            return true;
        }
        if (FakeDT.armySize() >= 2 && FakeDT.completed(CYBERNETICS_CORE) > 0 && FakeDT.completed(ROBOTICS_FACILITY) == 1 && FakeDT.count(OBSERVATORY) == 0) {
            return true;
        }
        return FakeDT.armySize() >= 2 && FakeDT.completed(CYBERNETICS_CORE) > 0 && FakeDT.completed(OBSERVATORY) == 1 && FakeDT.count(OBSERVER) == 0;
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Gateway) {
            if (this.pauseProduction()) {
                return true;
            }
            if (!agent.unit.isTraining()) {
                if (!this.transition) {
                    if (self.completedUnitCount(UnitType.Protoss_Templar_Archives) > 0) {
                        agent.unit.train(UnitType.Protoss_Dark_Templar);
                    } else if (bot.getAvailableMinerals() >= 250 && FakeDT.gas() >= 50 && (FakeDT.gas() >= 150 || FakeDT.count(DRAGOON) < 2)) {
                        agent.unit.train(DRAGOON);
                    }
                } else if (self.completedUnitCount(UnitType.Protoss_Templar_Archives) > 0 && UnitTracker.count(UnitType.Protoss_Dark_Templar) < 2) {
                    agent.unit.train(UnitType.Protoss_Dark_Templar);
                } else if ((UnitTracker.count(UnitType.Protoss_Zealot) <= UnitTracker.count(UnitType.Protoss_Dragoon) || self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) == 0) && bot.getAvailableMinerals() >= 100) {
                    agent.unit.build(UnitType.Protoss_Zealot);
                } else if (UnitTracker.count(UnitType.Protoss_Zealot) > UnitTracker.count(UnitType.Protoss_Dragoon) && bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                    agent.unit.build(UnitType.Protoss_Dragoon);
                }
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Citadel_of_Adun && !agent.unit.isUpgrading()) {
            if (bot.getAvailableGas() >= UpgradeType.Leg_Enhancements.gasPrice() && bot.getAvailableMinerals() >= UpgradeType.Leg_Enhancements.mineralPrice()) {
                agent.unit.upgrade(UpgradeType.Leg_Enhancements);
            }
        } else if (agent.unit.getType() == ROBOTICS_FACILITY) {
            if (FakeDT.count(OBSERVER) < 3 && FakeDT.minerals() >= 25 && FakeDT.gas() >= 75 && !agent.unit.isTraining()) {
                agent.unit.build(OBSERVER);
            }
            return true;
        }
        return super.overrideStructureOrder(game, self, bot, agent);
    }
}

