/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.buildingplacement.BaseBuildSite;
import com.tyr.buildingplacement.BuildCommand;
import com.tyr.builds.BuildOrder;
import com.tyr.unitgroups.MineralWorkers;

public class ExpandPart
extends BuildOrder {
    private UnitType building;
    private int requiredMinerals;
    public static int maximumCcs = 100;
    public boolean takeGasNext = false;

    public ExpandPart() {
    }

    public ExpandPart(boolean takeGasNext) {
        this.takeGasNext = takeGasNext;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        this.building = self.getRace() == Race.Terran ? UnitType.Terran_Command_Center : (self.getRace() == Race.Protoss ? UnitType.Protoss_Nexus : UnitType.Zerg_Hatchery);
        this.requiredMinerals = this.building.mineralPrice() - 50;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (UnitTracker.getCcCount() >= maximumCcs) {
            return;
        }
        if (!EnemyManager.getManager().isInvaderWorker()) {
            return;
        }
        for (BuildCommand command : bot.buildCommands) {
            if (!command.building.isResourceDepot()) continue;
            return;
        }
        int patchCount = 0;
        int totalMineralsLeft = bot.getAvailableMinerals();
        for (MineralWorkers base : bot.workForce.mineralWorkers) {
            patchCount += base.minerals.size();
            for (Unit patch : base.minerals) {
                totalMineralsLeft += patch.getResources();
            }
        }
        if (!(bot.getAvailableMinerals() < this.requiredMinerals && patchCount > 6 && totalMineralsLeft > 800 || UnitTracker.getCcCount() >= 3 && patchCount * 2 + 4 >= bot.workForce.units.size() + bot.builders.units.size() && totalMineralsLeft > 800)) {
            bot.spaceManager.build(this.building, null, new BaseBuildSite(this.takeGasNext));
            this.takeGasNext = false;
        }
    }
}

