/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.ConjRequirement;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.BuildAtLocationSolution;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.DefendMainTask;
import com.tyr.unitgroups.DefendingWorkers;

public class CarrierRush
extends CompositeBuildOrder {
    private ConstantPushTask constantPushTask;
    private boolean attackStarted = false;
    private boolean makeDragoons = false;
    int requiredDragoons = 0;
    private int armySize = 9;
    private int retreatSize = 4;
    boolean expand = true;
    boolean cannonDefense = false;
    boolean defensesInitialized = false;
    private int cannonCount = 10;

    public CarrierRush() {
    }

    public CarrierRush(boolean makeDragoons, boolean cannonDefense) {
        this.makeDragoons = makeDragoons;
        if (makeDragoons) {
            this.requiredDragoons = 20;
        }
        this.cannonDefense = cannonDefense;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(40);
        Settings.setDefendExpandDist(2000);
        Settings.setSmallInvasionDist(768);
        Settings.setLargeInvasionDist(1024);
        Settings.setWorkersPerGas(3);
        Attack.dontWaitAtCannon = true;
        DefendMainTask.maxFlyerDefense = true;
        this.add(new ExpandPart(true));
        ExpandPart.maximumCcs = 1;
        this.add(new WorkerScoutPart(1600));
        DefendingWorkers.stop = true;
        super.initialize(game, self, bot);
    }

    private Position getDefensivePosition() {
        Position location = SpaceManager.getNatural();
        return SpaceManager.getDefensePos(location);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        super.onFrame(game, self, bot);
        if (this.expand) {
            ExpandPart.maximumCcs = 2;
        }
        if (!this.attackStarted && CarrierRush.completed(CARRIER) >= this.armySize) {
            this.attackStarted = true;
            Settings.setMaximumWorkers(60);
            this.constantPushTask = new ConstantPushTask(CARRIER, 0);
            bot.taskManager.potentialTasks.add(this.constantPushTask);
        }
        if (CarrierRush.minerals() >= 1000 && !this.cannonDefense) {
            ExpandPart.maximumCcs = 3;
        }
        if (this.constantPushTask != null && CarrierRush.completed(CARRIER) <= this.retreatSize) {
            this.constantPushTask.stop = true;
        }
        if (this.constantPushTask != null && CarrierRush.completed(CARRIER) >= this.armySize) {
            this.constantPushTask.stop = false;
        }
        if (!this.defensesInitialized && game.getFrameCount() >= 100) {
            this.defensesInitialized = true;
            Position defensivePosition = this.getDefensivePosition();
            BuildAtLocationTask buildTask = new BuildAtLocationTask(defensivePosition, true);
            buildTask.addBuilding(UnitType.Protoss_Pylon, new UnitRequirement(UnitType.Protoss_Probe, 7));
            buildTask.addBuilding(UnitType.Protoss_Forge, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Pylon, 1, true)).addRequirement(new CostRequirement(100, 0)));
            BuildAtLocationSolution.buildingDistance = 300;
            int i = 0;
            while (i < this.cannonCount) {
                buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Forge, 1, true)).addRequirement(new CostRequirement(150, 0)));
                ++i;
            }
            buildTask.addBuilding(UnitType.Protoss_Pylon, new ConjRequirement().addRequirement(new CostRequirement(800, 0)));
            i = 0;
            while (i < this.cannonCount) {
                buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Forge, 1, true)).addRequirement(new UnitRequirement(NEXUS, 2, true)).addRequirement(new CostRequirement(800, 0)));
                ++i;
            }
            bot.taskManager.potentialTasks.add(buildTask);
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Protoss_Gateway) * 3 + UnitTracker.getCcCount() * 3 + CarrierRush.count(STARGATE) * 16 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (SpaceManager.noPower && CarrierRush.minerals() >= 100 && CarrierRush.count(PYLON) == CarrierRush.completed(PYLON)) {
            bot.spaceManager.build(PYLON);
        }
        if (!(bot.getAvailableMinerals() < 150 || UnitTracker.count(UnitType.Protoss_Gateway) != 0 || self.completedUnitCount(UnitType.Protoss_Pylon) <= 0 || CarrierRush.count(NEXUS) <= 1 && CarrierRush.minerals() < 400 && this.expand)) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (this.makeDragoons && CarrierRush.count(GATEWAY) < 3 && CarrierRush.completed(CYBERNETICS_CORE) > 0 && CarrierRush.minerals() >= 150) {
            bot.spaceManager.build(GATEWAY);
        }
        if (!(bot.getAvailableMinerals() < 100 || UnitTracker.getGeyserCount() <= 0 || UnitTracker.count(UnitType.Protoss_Gateway) <= 0 || CarrierRush.count(NEXUS) <= 1 && CarrierRush.minerals() < 400 && this.expand)) {
            bot.spaceManager.build(UnitType.Protoss_Assimilator);
        }
        if (!(bot.getAvailableMinerals() < 200 || UnitTracker.count(UnitType.Protoss_Cybernetics_Core) != 0 || self.completedUnitCount(UnitType.Protoss_Gateway) <= 0 || CarrierRush.count(NEXUS) <= 1 && CarrierRush.minerals() < 400 && this.expand)) {
            bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
        }
        if (!(bot.getAvailableMinerals() < 150 || bot.getAvailableGas() < 150 || UnitTracker.count(UnitType.Protoss_Cybernetics_Core) <= 0 || UnitTracker.count(UnitType.Protoss_Stargate) >= 2 || CarrierRush.count(NEXUS) <= 1 && CarrierRush.minerals() < 400 && this.expand)) {
            bot.spaceManager.build(UnitType.Protoss_Stargate);
        }
        if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 400 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Stargate) == 2) {
            bot.spaceManager.build(UnitType.Protoss_Stargate);
        }
        if (CarrierRush.count(FLEET_BEACON) == 0 && CarrierRush.gas() >= 200 && CarrierRush.minerals() >= 300 && CarrierRush.completed(STARGATE) > 0) {
            bot.spaceManager.build(FLEET_BEACON);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining()) {
            if (CarrierRush.count(DRAGOON) < this.requiredDragoons && CarrierRush.completed(CYBERNETICS_CORE) > 0 && CarrierRush.minerals() >= 125 && CarrierRush.gas() >= 50) {
                agent.unit.train(DRAGOON);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading()) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading()) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Robotics_Facility) {
            if (UnitTracker.count(UnitType.Protoss_Observer) < 2 && bot.getAvailableMinerals() >= 25 && bot.getAvailableGas() >= 75 && !agent.unit.isTraining()) {
                agent.unit.build(UnitType.Protoss_Observer);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Stargate) {
            if (bot.getAvailableMinerals() >= 350 && bot.getAvailableGas() >= 250 && !agent.unit.isTraining() && CarrierRush.completed(FLEET_BEACON) > 0) {
                agent.unit.build(CARRIER);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Citadel_of_Adun && !agent.unit.isUpgrading()) {
            return true;
        }
        if (agent.unit.getType() == FLEET_BEACON && self.getUpgradeLevel(UpgradeType.Carrier_Capacity) == 0 && CarrierRush.gas() >= 100 && CarrierRush.minerals() >= 100) {
            agent.unit.upgrade(UpgradeType.Carrier_Capacity);
        }
        return false;
    }
}

