/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.TechType;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.GenericPartFactory;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.DisjRequirement;
import com.tyr.requirements.LinearMax;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.AssignScience;
import com.tyr.tasks.AttackTask;
import com.tyr.unitgroups.MineralWorkers;

public class Bio
extends CompositeBuildOrder {
    private boolean takeExpands = false;
    private int mode = GREEDY;
    public static int GREEDY = 0;
    public static int DEFENSIVE = 1;
    public static int ULTRA_DEFENSIVE = 2;
    public static int RUSH = 3;
    private int minimumArmySize = 30;
    private int maximumArmySize = 60;
    private boolean buildTurrets = false;
    private boolean buildNaturalTurret = false;
    private boolean vesselSupport = true;
    private int turretPos;
    private int depotTurrets = 0;

    public Bio() {
    }

    public Bio(int mode) {
        this.mode = mode;
        if (mode == RUSH) {
            this.minimumArmySize = 15;
        }
    }

    public Bio(int mode, int minimumArmySize) {
        this.mode = mode;
        this.minimumArmySize = minimumArmySize;
    }

    public Bio(int mode, int minimumArmySize, boolean buildTurrets, boolean buildNaturalTurret, int depotTurrets) {
        this.mode = mode;
        this.minimumArmySize = minimumArmySize;
        this.buildTurrets = buildTurrets;
        this.buildNaturalTurret = buildNaturalTurret;
        this.depotTurrets = depotTurrets;
    }

    public Bio(int mode, int minimumArmySize, int maximumArmySize) {
        this.mode = mode;
        this.minimumArmySize = minimumArmySize;
        this.maximumArmySize = maximumArmySize;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        if (this.mode == DEFENSIVE || this.mode == ULTRA_DEFENSIVE) {
            Settings.setLargeInvasionDist(720);
        }
        Settings.setRequiredSize(this.minimumArmySize);
        Settings.setMaximumSize(this.maximumArmySize);
        Settings.setWorkersPerGas(1);
        if (this.mode == RUSH) {
            Settings.setMaximumWorkers(20);
        }
        if (game.enemy().getRace() == Race.Zerg && this.mode == DEFENSIVE) {
            bot.bunkers.maximumRepair = 1;
        }
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setCost(this.mode == DEFENSIVE ? 100 : 150, 0).create());
        GenericPartFactory barracks2Factory = new GenericPartFactory(UnitType.Terran_Barracks).setMax(2).setCost(this.mode == DEFENSIVE ? 100 : 150, 0);
        this.add(barracks2Factory.create());
        if (this.mode == GREEDY) {
            barracks2Factory.add(new UnitRequirement(UnitType.Terran_Command_Center, 2));
        }
        if (this.mode != GREEDY && this.mode != RUSH) {
            barracks2Factory.add(new UnitRequirement(UnitType.Terran_Bunker));
        }
        GenericPartFactory barracksFactory = new GenericPartFactory(UnitType.Terran_Barracks).setMax(8).setCost(this.mode == DEFENSIVE ? 100 : 150, 0).add(new LinearMax(UnitType.Terran_Command_Center, UnitType.Terran_Barracks, 3, 0, false)).add(new UnitRequirement(UnitType.Terran_Academy));
        if (this.mode == GREEDY) {
            barracksFactory.add(new UnitRequirement(UnitType.Terran_Command_Center, 2));
        }
        if (this.mode != GREEDY && this.mode != RUSH) {
            barracksFactory.add(new UnitRequirement(UnitType.Terran_Bunker));
        }
        if (this.vesselSupport) {
            barracksFactory.add(new DisjRequirement().addRequirement(new UnitRequirement(UnitType.Terran_Science_Facility)).addRequirement(new CostRequirement(350, 0)));
        }
        this.add(barracksFactory.create());
        GenericPartFactory academyFactory = new GenericPartFactory(UnitType.Terran_Academy).add(new UnitRequirement(UnitType.Terran_Barracks)).add(new UnitRequirement(UnitType.Terran_Refinery));
        if (this.mode == GREEDY) {
            academyFactory.add(new UnitRequirement(UnitType.Terran_Command_Center, 2));
        }
        this.add(academyFactory.create());
        this.add(new GenericPartFactory(UnitType.Terran_Engineering_Bay).setMax(2).add(new UnitRequirement(UnitType.Terran_Marine, 10)).add(new UnitRequirement(UnitType.Terran_Academy)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Factory).add(new UnitRequirement(UnitType.Terran_Barracks, this.vesselSupport ? 2 : 6)).add(new UnitRequirement(UnitType.Terran_Engineering_Bay, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Starport).add(new UnitRequirement(UnitType.Terran_Barracks, this.vesselSupport ? 2 : 6)).add(new UnitRequirement(UnitType.Terran_Engineering_Bay, 2)).add(new UnitRequirement(UnitType.Terran_Factory, 1, true)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Science_Facility).add(new UnitRequirement(UnitType.Terran_Barracks, this.vesselSupport ? 2 : 6)).add(new UnitRequirement(UnitType.Terran_Engineering_Bay, 2)).add(new UnitRequirement(UnitType.Terran_Starport, 1, true)).create());
        bot.taskManager.potentialTasks.add(new AssignScience());
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Going bio.");
        StopWatch watch = new StopWatch();
        watch.start();
        super.onFrame(game, self, bot);
        long time = watch.time();
        if (time > 55L) {
            DebugMessages.addMessage("Bio super time: " + time);
        }
        if (UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0 && this.vesselSupport && bot.getAvailableGas() < 400) {
            Settings.setWorkersPerGas(3);
        } else if (UnitTracker.count(UnitType.Terran_Barracks) > 5 || UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0) {
            Settings.setWorkersPerGas(2);
        }
        if (!(this.takeExpands || this.mode == RUSH && bot.getAvailableMinerals() < 600 || !AttackTask.getAttackSent() && this.mode == ULTRA_DEFENSIVE)) {
            if (this.mode == RUSH) {
                Settings.setMaximumWorkers(45);
            }
            this.add(new ExpandPart(true));
            this.takeExpands = true;
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio tier 1 time: " + time);
        }
        if (!(bot.getAvailableMinerals() < 100 || UnitTracker.getGeyserCount() <= 0 || UnitTracker.count(UnitType.Terran_Barracks) < 1 || UnitTracker.count(UnitType.Terran_Refinery) != 0 && UnitTracker.count(UnitType.Terran_Starport) <= 0 || UnitTracker.getCcCount() < 2 && this.mode == GREEDY || UnitTracker.count(UnitType.Terran_Bunker) <= 0 && this.mode != GREEDY && this.mode != RUSH)) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio refinery: " + time + " geyserCount: " + UnitTracker.getGeyserCount());
        }
        if (this.buildNaturalTurret && bot.getAvailableMinerals() >= 75 && self.completedUnitCount(UnitType.Terran_Engineering_Bay) > 0) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                if (structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200.0) continue;
                if (structures.getUnitCount(UnitType.Terran_Missile_Turret) != 0) break;
                bot.spaceManager.buildDefensive(UnitType.Terran_Missile_Turret, structures);
                break;
            }
        }
        if (this.mode != GREEDY && this.mode != RUSH && bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                int count = structures.getUnitCount(UnitType.Terran_Bunker);
                if (bot.defensiveStructures.size() > 1 && structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200.0 || count >= (this.mode == ULTRA_DEFENSIVE ? 2 : 1)) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio bunker time: " + time);
        }
        if (this.buildTurrets && self.completedUnitCount(UnitType.Terran_Engineering_Bay) >= 1 && bot.getAvailableMinerals() >= 75) {
            boolean built = false;
            int i = 0;
            while (i < bot.workForce.mineralWorkers.size()) {
                MineralWorkers workers = bot.workForce.mineralWorkers.get((i + this.turretPos) % bot.workForce.mineralWorkers.size());
                if (bot.spaceManager.build(UnitType.Terran_Missile_Turret, null, workers.turretSite)) {
                    built = true;
                    this.turretPos = (i + this.turretPos + 1) % bot.workForce.mineralWorkers.size();
                    break;
                }
                ++i;
            }
            if (!built) {
                DebugMessages.addMessage("No placement found for any turret.");
            }
        }
        if (bot.getAvailableMinerals() >= 75 && self.completedUnitCount(UnitType.Terran_Missile_Turret) >= 4 && this.depotTurrets > 0) {
            bot.spaceManager.build(UnitType.Terran_Missile_Turret, null, bot.spaceManager.depotBuildSite);
            --this.depotTurrets;
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio turrets time: " + time);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            if (this.mode == GREEDY && UnitTracker.getCcCount() <= 1) {
                return true;
            }
            if (!agent.unit.isTraining() && Tyr.bot.getAvailableGas() >= 25 && Tyr.bot.getAvailableMinerals() >= 50 && self.completedUnitCount(UnitType.Terran_Academy) > 0 && UnitTracker.count(UnitType.Terran_Medic) * 4 < UnitTracker.count(UnitType.Terran_Marine) - 4 * UnitTracker.count(UnitType.Terran_Bunker)) {
                agent.unit.train(UnitType.Terran_Medic);
                return true;
            }
        } else if (agent.unit.getType() == UnitType.Terran_Academy) {
            if (bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100 && !agent.unit.isResearching() && !self.hasResearched(TechType.Stim_Packs)) {
                agent.unit.research(TechType.Stim_Packs);
                return true;
            }
            if (bot.getAvailableGas() >= 150 && bot.getAvailableMinerals() >= 150 && !agent.unit.isResearching()) {
                agent.unit.upgrade(UpgradeType.U_238_Shells);
            }
        } else {
            if (agent.unit.getType() == UnitType.Terran_Starport) {
                if (this.vesselSupport && agent.unit.getAddon() == null && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                    agent.unit.buildAddon(UnitType.Terran_Control_Tower);
                }
                if (this.vesselSupport && !agent.unit.isTraining() && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 225) {
                    agent.unit.train(UnitType.Terran_Science_Vessel);
                }
                return true;
            }
            if (agent.unit.getType() == UnitType.Terran_Factory) {
                if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 100 && Tyr.game.enemy().getRace() == Race.Protoss) {
                    agent.unit.train(UnitType.Terran_Vulture);
                }
                return true;
            }
            if (agent.unit.getType() == UnitType.Terran_Science_Facility) {
                if (this.vesselSupport && !self.hasResearched(TechType.Irradiate) && bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 200) {
                    agent.unit.research(TechType.Irradiate);
                    return true;
                }
                return false;
            }
        }
        return false;
    }
}

