/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.CompactBuildSite;
import com.tyr.builds.BuildOrder;
import com.tyr.tasks.AttackRegroupSolution;
import com.tyr.tasks.DefendMainTask;

public class AntiWorkerRush
extends BuildOrder {
    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(10);
        Settings.setMaximumSize(60);
        DefendMainTask.workerRush = true;
        AttackRegroupSolution.focusWorkers = false;
        Settings.setLargeInvasionDist(320);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        long time;
        Settings.setWorkersPerGas(0);
        DebugMessages.addMessage("Going bio.");
        StopWatch watch = new StopWatch();
        watch.start();
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) < 3) {
            bot.spaceManager.build(UnitType.Terran_Barracks, null, new CompactBuildSite());
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() <= Math.min(400, self.supplyUsed() + 4) && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Terran_Supply_Depot, null, new CompactBuildSite());
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio tier 1 time: " + time);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Terran_Command_Center) {
            if (bot.getAvailableMinerals() >= 50 && !agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_SCV) < 12) {
                agent.unit.train(UnitType.Terran_SCV);
                return true;
            }
            if (UnitTracker.count(UnitType.Terran_Barracks) == 0 && bot.getAvailableMinerals() < 200) {
                return true;
            }
            if (UnitTracker.count(UnitType.Terran_Marine) < 2 && bot.getAvailableMinerals() < 100) {
                return true;
            }
            if (bot.getAvailableMinerals() >= 50 && !agent.unit.isTraining()) {
                agent.unit.train(UnitType.Terran_SCV);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks && !agent.unit.isTraining() && bot.getAvailableMinerals() >= 50) {
            agent.unit.train(UnitType.Terran_Marine);
        }
        return false;
    }
}

