/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Command;

public class MedicAttack
extends Command {
    private Position target;
    private Unit defendingUnit;

    public MedicAttack(Agent agent, Position target) {
        super(agent);
        this.target = target;
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        this.agent.drawCircle(Color.White);
        if (this.target == null || this.agent.distanceSquared(this.target) <= 16384) {
            return;
        }
        Order order = this.agent.unit.getOrder();
        Position orderTarget = this.agent.unit.getOrderTargetPosition();
        if (this.agent.unit.isHoldingPosition() || this.agent.unit.isIdle()) {
            Tyr.drawCircle(this.agent.unit.getPosition(), Color.Green, 6);
            this.agent.attack(this.target);
        } else {
            boolean enemyClose = false;
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType().groundWeapon() == WeaponType.None || this.agent.distanceSquared(unit) > 16384) continue;
                enemyClose = true;
                break;
            }
            if (!enemyClose) {
                this.defendingUnit = null;
            }
            if (this.defendingUnit == null && enemyClose) {
                for (Unit unit : self.getUnits()) {
                    if (!unit.getType().isOrganic() || unit.getType() == UnitType.Terran_Medic || this.agent.distanceSquared(unit) > 65536) continue;
                    this.defendingUnit = unit;
                    this.agent.unit.follow(this.defendingUnit);
                    break;
                }
            }
            double dist = this.target.getDistance(orderTarget);
            if (order == Order.AttackMove && orderTarget != null && this.agent.unit.getTarget() == null && (Math.abs(this.target.getX() - orderTarget.getX()) >= 10 || Math.abs(this.target.getY() - orderTarget.getY()) >= 10 || dist >= 10.0)) {
                Tyr.drawCircle(this.agent.unit.getPosition(), Color.White, 6);
                this.agent.attack(this.target);
            }
        }
    }

    @Override
    public boolean replace(Command command) {
        if (!command.getClass().equals(MedicAttack.class)) {
            return true;
        }
        MedicAttack atkCom = (MedicAttack)command;
        this.agent.attack(this.target);
        this.target = atkCom.target;
        return false;
    }
}

