/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Command;
import java.util.ArrayList;

public class KillWorkers
extends Command {
    private Unit enemyWorker;
    public boolean breakOff = false;

    public KillWorkers(Agent agent) {
        super(agent);
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        if (this.agent.unit.isUnderAttack()) {
            this.breakOff = true;
        }
        if (this.enemyWorker != null) {
            if (this.enemyWorker.getHitPoints() <= 0 || this.enemyWorker.getRemoveTimer() != 0 || !this.enemyWorker.exists()) {
                this.enemyWorker = null;
            }
            if (this.enemyWorker != null && this.agent.distanceSquared(this.enemyWorker) >= 102400) {
                this.enemyWorker = null;
            }
        }
        if (this.enemyWorker == null) {
            this.findWorker();
            if (this.enemyWorker != null) {
                this.agent.unit.attack(this.enemyWorker);
            }
        }
    }

    private void findWorker() {
        ArrayList<Unit> enemies = EnemyManager.getEnemyUnits();
        double bestDistance = 2.147483647E9;
        for (Unit enemy : enemies) {
            if (!enemy.getType().isWorker()) continue;
            double newDist = this.agent.distanceSquared(enemy);
            if (this.enemyWorker != null && !(newDist < bestDistance)) continue;
            this.enemyWorker = enemy;
            bestDistance = newDist;
        }
    }

    @Override
    public boolean replace(Command command) {
        return true;
    }

    public boolean getBreakOff() {
        return this.breakOff;
    }
}

