/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Race;
import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.builds.BBS;
import com.tyr.builds.BuildOrder;
import com.tyr.builds.CannonWall;
import com.tyr.builds.CarrierRush;
import com.tyr.builds.DefensiveTerran;
import com.tyr.builds.ProtossFE;
import com.tyr.builds.PvT;
import com.tyr.builds.StandardZerg;
import com.tyr.builds.TAntiZealot;
import com.tyr.builds.TFastExpand;
import com.tyr.builds.TvPGeneric;
import com.tyr.builds.TvZFE;
import com.tyr.builds.ZealotPush;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.ScoutGroup;
import java.util.ArrayList;
import java.util.HashMap;

public class Strategy {
    public String code;
    private BuildOrder counter;
    private int opponentStrategy;
    private int scoutTiming;
    private int nscouts;
    public boolean triggerDebug = false;
    public Task[] tasks;
    public static Strategy chosenStrategy;
    private static ArrayList<String> oldFlags;
    private static ArrayList<String> newFlags;
    private static boolean lost;
    private static ArrayList<String> file;

    static {
        oldFlags = new ArrayList();
        newFlags = new ArrayList();
        lost = false;
    }

    public Strategy(String code, BuildOrder counter) {
        this(code, counter, ScoutGroup.unknown);
    }

    public Strategy(String code, BuildOrder counter, int opponentStrategy) {
        this(code, counter, opponentStrategy, -1, 0, new Task[0]);
    }

    public Strategy(String code, BuildOrder counter, int opponentStrategy, Task[] tasks) {
        this(code, counter, opponentStrategy, -1, 0, tasks);
    }

    public Strategy(String code, BuildOrder counter, int opponentStrategy, int scoutTiming, int nscouts, Task[] tasks) {
        this.code = code;
        this.counter = counter;
        this.opponentStrategy = opponentStrategy;
        this.scoutTiming = scoutTiming;
        this.nscouts = nscouts;
        this.tasks = tasks;
    }

    public static Strategy determine() {
        Strategy[] strategies = Strategy.determineStrategies();
        return Strategy.pickStrategy(strategies);
    }

    public static void initialize() {
        file = DebugMessages.readFile();
        Strategy.getFlags();
    }

    public static Strategy pickStrategy(Strategy[] strategies) {
        int win;
        HashMap<String, Integer> losses = new HashMap<String, Integer>();
        HashMap<String, Integer> wins = new HashMap<String, Integer>();
        HashMap<String, Integer> recentLosses = new HashMap<String, Integer>();
        HashMap<String, Integer> recentWins = new HashMap<String, Integer>();
        int i = file.size() - 1;
        while (i >= 0) {
            String line = file.get(i);
            win = 0;
            String[] words = line.split(" ");
            String code = "";
            String[] stringArray = words;
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (word.equals("win")) {
                    win = 1;
                }
                Strategy[] strategyArray = strategies;
                int n3 = strategies.length;
                int n4 = 0;
                while (n4 < n3) {
                    Strategy strat = strategyArray[n4];
                    if (strat.code.equals(word)) {
                        code = word;
                    }
                    ++n4;
                }
                ++n2;
            }
            Strategy.inc(win != 0 ? wins : losses, code);
            if (Strategy.get(recentWins, code) + Strategy.get(recentLosses, code) < 5) {
                Strategy.inc(win != 0 ? recentWins : recentLosses, code);
            }
            --i;
        }
        boolean trialPhase = false;
        Strategy[] strategyArray = strategies;
        int words = strategies.length;
        win = 0;
        while (win < words) {
            Strategy strat = strategyArray[win];
            if (Strategy.get(losses, strat.code) < 3) {
                trialPhase = true;
            }
            ++win;
        }
        Strategy choice = null;
        if (trialPhase) {
            int score = Integer.MIN_VALUE;
            Strategy[] strategyArray2 = strategies;
            int n = strategies.length;
            int n5 = 0;
            while (n5 < n) {
                Strategy strat = strategyArray2[n5];
                int newScore = 0;
                newScore -= Strategy.get(losses, strat.code);
                System.out.println("score with " + strat.code + ": " + (newScore += Strategy.get(wins, strat.code) / 4));
                if (newScore > score) {
                    score = newScore;
                    choice = strat;
                }
                ++n5;
            }
        } else {
            float score = -1.0f;
            Strategy[] strategyArray3 = strategies;
            int n = strategies.length;
            int n6 = 0;
            while (n6 < n) {
                Strategy strat = strategyArray3[n6];
                float newScore = (float)Strategy.get(recentWins, strat.code) / ((float)Strategy.get(recentLosses, strat.code) + (float)Strategy.get(recentWins, strat.code));
                if (newScore > score) {
                    score = newScore;
                    choice = strat;
                }
                ++n6;
            }
        }
        DebugMessages.log("Chosen strategy: " + choice.code);
        return choice;
    }

    private static void inc(HashMap<String, Integer> map, String key) {
        if (!map.containsKey(key)) {
            map.put(key, 0);
        }
        map.put(key, map.get(key) + 1);
    }

    private static int get(HashMap<String, Integer> map, String key) {
        return map.containsKey(key) ? map.get(key) : 0;
    }

    private static Strategy[] determineStrategies() {
        if (Tyr.self.getRace() == Race.Terran) {
            if (Tyr.game.enemy().getRace() == Race.Protoss) {
                if (!Strategy.flagSet("NZ") && lost) {
                    System.out.println("Countering zealots.");
                    return new Strategy[]{new Strategy("ANTIZ", new TvPGeneric(), ScoutGroup.zealotPush), new Strategy("VPUSH", new TAntiZealot(true), ScoutGroup.zealotPush)};
                }
                return new Strategy[]{new Strategy("TvP", new TvPGeneric()), new Strategy("MPUSH", new TAntiZealot(true, false, true, true)), new Strategy("FE", new TFastExpand(new TvPGeneric())), new Strategy("BBS", new BBS())};
            }
            if (Tyr.game.enemy().getRace() == Race.Terran) {
                return new Strategy[]{new Strategy("TvP", new TvPGeneric()), new Strategy("MPUSH", new TAntiZealot(true, false, true, true)), new Strategy("FE", new TFastExpand(new TvPGeneric())), new Strategy("BBS", new BBS())};
            }
            if (Tyr.game.enemy().getRace() == Race.Zerg) {
                return new Strategy[]{new Strategy("TvZFE", new TvZFE())};
            }
            return new Strategy[]{new Strategy("DEF", new DefensiveTerran())};
        }
        if (Tyr.self.getRace() == Race.Protoss) {
            boolean hideBuilds = false;
            if (Tyr.game.mapFileName().contains("Plasma")) {
                return new Strategy[]{new Strategy("CARRIER", new CarrierRush(true, false)), new Strategy("CARRIERDRAGOON", new CarrierRush())};
            }
            if (Tyr.game.mapFileName().contains("BlueStorm")) {
                return new Strategy[]{new Strategy("CARRIER", new CarrierRush(false, true)), new Strategy("ZP", new ZealotPush(false, false, true)), new Strategy("FEZEALOTS", new ProtossFE(2, false))};
            }
            if (Tyr.game.enemy().getRace() == Race.Terran) {
                return new Strategy[]{new Strategy("CANNONS", new CannonWall(false)), new Strategy("PvR", new PvT(25)), new Strategy("ZP", new ZealotPush(false, false)), new Strategy("FECANNONS", new CannonWall(true))};
            }
            if (Tyr.game.enemy().getRace() == Race.Protoss) {
                return new Strategy[]{new Strategy("CANNONS", new CannonWall(false)), new Strategy("PvR", new PvT(25)), new Strategy("ZP", new ZealotPush(false, false)), new Strategy("FECANNONS", new CannonWall(true))};
            }
            if (Tyr.game.enemy().getRace() == Race.Zerg) {
                return new Strategy[]{new Strategy("CANNONS", new CannonWall(false)), new Strategy("PvR", new PvT(25)), new Strategy("ZP", new ZealotPush(false, false)), new Strategy("FECANNONS", new CannonWall(true))};
            }
            return new Strategy[]{new Strategy("CANNONS", new CannonWall(false)), new Strategy("PvR", new PvT(25)), new Strategy("ZP", new ZealotPush(false, false)), new Strategy("FECANNONS", new CannonWall(true))};
        }
        return new Strategy[]{new Strategy("STANDARD", new StandardZerg())};
    }

    public static void getFlags() {
        for (String line : file) {
            String[] words;
            if (line.startsWith("flag:")) {
                System.out.println("flag read: " + line.substring(5));
                oldFlags.add(line.substring(5));
                continue;
            }
            String[] stringArray = words = line.split(" ");
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (word.equals("loss")) {
                    lost = true;
                }
                ++n2;
            }
        }
    }

    public static boolean flagSet(String flag) {
        return oldFlags.contains(flag) || newFlags.contains(flag);
    }

    public static void addFlag(String flag) {
        if (!Strategy.flagSet(flag)) {
            System.out.println("flag set: " + flag);
            newFlags.add(flag);
        }
    }

    public static void writeFlags() {
        for (String flag : newFlags) {
            System.out.println("storing flag: " + flag);
            DebugMessages.saveMessage("flag:" + flag);
            oldFlags.add(flag);
        }
        newFlags = new ArrayList();
    }

    public void set() {
        chosenStrategy = this;
        Tyr.bot.build = this.counter;
        Tyr.bot.scout.opponentStrategy = this.opponentStrategy;
        if (this.nscouts != 0) {
            Tyr.bot.scout.nscouts = this.nscouts;
            Tyr.bot.scout.workerScoutTiming = this.scoutTiming;
        }
        Task[] taskArray = this.tasks;
        int n = this.tasks.length;
        int n2 = 0;
        while (n2 < n) {
            Task task = taskArray[n2];
            Tyr.bot.taskManager.potentialTasks.add(task);
            ++n2;
        }
    }
}

