/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.Strategy;
import com.tyr.Tyr;
import com.tyr.builds.AntiIron;
import com.tyr.builds.AntiKill;
import com.tyr.builds.AntiWorkerRush;
import com.tyr.builds.BBS;
import com.tyr.builds.BuildOrder;
import com.tyr.builds.CannonWall;
import com.tyr.builds.DTPush;
import com.tyr.builds.DefensiveMech;
import com.tyr.builds.DefensiveTerran;
import com.tyr.builds.DragoonPush;
import com.tyr.builds.GatewayPush;
import com.tyr.builds.Mech;
import com.tyr.builds.OneBaseMech;
import com.tyr.builds.OneBaseTank;
import com.tyr.builds.ProtossFE;
import com.tyr.builds.PvIron;
import com.tyr.builds.PvT;
import com.tyr.builds.SafeTwoGate;
import com.tyr.builds.TAntiCannon;
import com.tyr.builds.TAntiZealot;
import com.tyr.builds.TFastExpand;
import com.tyr.builds.TankContain;
import com.tyr.builds.TvP;
import com.tyr.builds.TvPGeneric;
import com.tyr.builds.TwoBaseMech;
import com.tyr.builds.ZealotPush;
import com.tyr.tasks.SalesmenMarinesTask;
import com.tyr.tasks.SiegeNaturalTask;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.ScoutGroup;
import java.util.ArrayList;

public class PlayerProfile {
    private Race race;
    private String[][] names;
    private Strategy[] strategies;
    private BuildOrder counter;
    private int opponentStrategy;
    private int scoutTiming;
    private int nscouts;
    public boolean triggerDebug = false;
    public Task[] tasks;

    public PlayerProfile(Race race, BuildOrder counter, String name) {
        this(race, counter, (String[][])new String[][]{{name}});
    }

    public PlayerProfile(Race race, BuildOrder counter, String[][] names) {
        this(race, counter, names, ScoutGroup.unknown);
    }

    public PlayerProfile(Race race, Strategy[] strategies, String name) {
        this(race, strategies, (String[][])new String[][]{{name}});
    }

    public PlayerProfile(Race race, Strategy[] strategies, String[][] names) {
        this.race = race;
        this.strategies = strategies;
        int i = 0;
        while (i < names.length) {
            int j = 0;
            while (j < names[i].length) {
                names[i][j] = names[i][j].toLowerCase();
                ++j;
            }
            ++i;
        }
        this.names = names;
    }

    public PlayerProfile(Race race, BuildOrder counter, String[][] names, int opponentStrategy) {
        this(race, counter, names, opponentStrategy, -1, 0, new Task[0]);
    }

    public PlayerProfile(Race race, BuildOrder counter, String[][] names, int opponentStrategy, Task[] tasks) {
        this(race, counter, names, opponentStrategy, -1, 0, tasks);
    }

    public PlayerProfile(Race race, BuildOrder counter, String[][] names, int opponentStrategy, int scoutTiming, int nscouts, Task[] tasks) {
        this.race = race;
        this.names = names;
        this.counter = counter;
        int i = 0;
        while (i < names.length) {
            int j = 0;
            while (j < names[i].length) {
                names[i][j] = names[i][j].toLowerCase();
                ++j;
            }
            ++i;
        }
        this.opponentStrategy = opponentStrategy;
        this.scoutTiming = scoutTiming;
        this.nscouts = nscouts;
        this.tasks = tasks;
    }

    public boolean match(Game game, Tyr bot) {
        Player enemy = game.enemy();
        if (enemy.getRace() != this.race) {
            return false;
        }
        String nameLower = DebugMessages.getEnemyName().toLowerCase();
        String[][] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String[] name = stringArray[n2];
            boolean matches = true;
            Object[] objectArray = name;
            int n3 = name.length;
            int n4 = 0;
            while (n4 < n3) {
                String namePart = objectArray[n4];
                if (!nameLower.contains(namePart)) {
                    matches = false;
                    break;
                }
                ++n4;
            }
            if (this.triggerDebug) {
                matches = true;
            }
            if (matches) {
                DebugMessages.log("Picked: " + this.names[0][0]);
                if (this.strategies != null) {
                    Strategy pickedStrategy = Strategy.pickStrategy(this.strategies);
                    pickedStrategy.set();
                    DebugMessages.log("Strategy: " + pickedStrategy.getClass());
                    return true;
                }
                bot.build = this.counter;
                bot.scout.opponentStrategy = this.opponentStrategy;
                if (this.nscouts != 0) {
                    bot.scout.nscouts = this.nscouts;
                    bot.scout.workerScoutTiming = this.scoutTiming;
                }
                objectArray = this.tasks;
                n3 = this.tasks.length;
                n4 = 0;
                while (n4 < n3) {
                    Object task = objectArray[n4];
                    Tyr.bot.taskManager.potentialTasks.add((Task)task);
                    ++n4;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ArrayList<PlayerProfile> getProfiles() {
        if (Tyr.self.getRace() == Race.Terran) {
            return PlayerProfile.getTerranProfiles();
        }
        if (Tyr.self.getRace() == Race.Protoss) {
            return PlayerProfile.getProtossProfiles();
        }
        if (Tyr.self.getRace() == Race.Zerg) {
            return PlayerProfile.getZergProfiles();
        }
        return new ArrayList<PlayerProfile>();
    }

    public static ArrayList<PlayerProfile> getZergProfiles() {
        ArrayList<PlayerProfile> result = new ArrayList<PlayerProfile>();
        return result;
    }

    public static ArrayList<PlayerProfile> getProtossProfiles() {
        ArrayList<PlayerProfile> result = new ArrayList<PlayerProfile>();
        result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("DT", new DTPush()), new Strategy("PvT", new PvT(25)), new Strategy("CANNONS", new CannonWall())}, (String[][])new String[][]{{"Mega"}}));
        result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("DT", new DTPush()), new Strategy("PvT", new PvT(25)), new Strategy("CANNONS", new CannonWall())}, (String[][])new String[][]{{"Skynet"}, {"Andrew", "Smith"}}));
        result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("DT", new DTPush()), new Strategy("PvT", new PvT(25)), new Strategy("CANNONS", new CannonWall())}, (String[][])new String[][]{{"Xelnaga"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new DTPush(), (String[][])new String[][]{{"Skynet"}, {"Andrew", "Smith"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new ProtossFE(1, false), (String[][])new String[][]{{"Tomas", "Vajda"}, {"Thomas", "Vajda"}, {"XIMP"}}));
        boolean skipHardcodedBuilds = false;
        if (Tyr.game.mapFileName().contains("Plasma")) {
            return result;
        }
        if (Tyr.game.mapFileName().contains("Blue") && Tyr.game.mapFileName().contains("Storm")) {
            return result;
        }
        result.add(new PlayerProfile(Race.Zerg, new Strategy[]{new Strategy("CANNONS", new CannonWall())}, (String[][])new String[][]{{"Neo", "Edmund"}}));
        result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("PvIron", new PvIron().fullAssault().noCarriers())}, (String[][])new String[][]{{"Iron"}}));
        result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("PvR", new PvT(40).delayUpgrades().limitDefendingGoons().counterAttackTanks().useArbiters(false).dragoonsFirst().setExtraDragoons(-8))}, (String[][])new String[][]{{"Krasi"}}));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new ProtossFE(2, false), (String[][])new String[][]{{"ICE"}}));
        result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("GATEWAYTIMING", new DragoonPush(25, true, false, false, true, false, false, false)), new Strategy("ZP", new ZealotPush(false, false))}, (String[][])new String[][]{{"Kaon"}}));
        if (Settings.getDebug()) {
            result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("FEZEALOTS", new ProtossFE(2, false))}, (String[][])new String[][]{{"leta"}, {"Martin", "Rooijackers"}}));
        } else {
            result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("FEZEALOTS", new ProtossFE(2, false))}, (String[][])new String[][]{{"leta"}, {"Martin", "Rooijackers"}}));
        }
        result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("FECANNONS", new CannonWall(true)), new Strategy("DT", new DTPush())}, (String[][])new String[][]{{"AIUR"}, {"Florian", "Richoux"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new ProtossFE(4, true), (String[][])new String[][]{{"Bereaver"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new CannonWall(), (String[][])new String[][]{{"PurpleCheese"}}));
        result.add(new PlayerProfile(Race.Unknown, new Strategy[]{new Strategy("CannonWall", new CannonWall(false, 2)), new Strategy("PvR", new PvT(25)), new Strategy("ZP", new ZealotPush(false, false)), new Strategy("FECANNONS", new CannonWall(true))}, (String[][])new String[][]{{"steamhammer"}, {"randomhammer"}}));
        result.add(new PlayerProfile(Race.Zerg, new Strategy[]{new Strategy("CannonWall", new CannonWall(false, 2)), new Strategy("PvR", new PvT(25)), new Strategy("ZP", new ZealotPush(false, false)), new Strategy("FECANNONS", new CannonWall(true))}, (String[][])new String[][]{{"steamhammer"}, {"randomhammer"}}));
        result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("CannonWall", new CannonWall(false, 2)), new Strategy("PvR", new PvT(25)), new Strategy("ZP", new ZealotPush(false, false)), new Strategy("FECANNONS", new CannonWall(true))}, (String[][])new String[][]{{"steamhammer"}, {"randomhammer"}}));
        result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("CannonWall", new CannonWall(false, 2)), new Strategy("PvR", new PvT(25)), new Strategy("ZP", new ZealotPush(false, false)), new Strategy("FECANNONS", new CannonWall(true))}, (String[][])new String[][]{{"steamhammer"}, {"randomhammer"}}));
        result.add(new PlayerProfile(Race.Zerg, new Strategy[]{new Strategy("SAFETWOGATE", new SafeTwoGate(20, false, false, false, true, false))}, (String[][])new String[][]{{"Overkill"}, {"Sijia", "Xu"}}));
        result.add(new PlayerProfile(Race.Zerg, (BuildOrder)new PvT(25), (String[][])new String[][]{{"arrak"}}));
        result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("FECANNONS", new CannonWall(true)), new Strategy("CANNONS", new CannonWall().noCannonDefense().dragoonOnly().doNotExpand()), new Strategy("PvT", new PvT(25))}, (String[][])new String[][]{{"YuanhengZhu"}, {"Yuanheng", "Zhu"}, {"Juno"}}));
        if (Settings.getDebug()) {
            result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new ZealotPush(), (String[][])new String[][]{{"BigEyes"}}));
            result.add(new PlayerProfile(Race.Terran, (BuildOrder)new ZealotPush(), (String[][])new String[][]{{"HannesBredberg"}}));
            result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new ZealotPush(), (String[][])new String[][]{{"Pinfel"}}));
            result.add(new PlayerProfile(Race.Zerg, (BuildOrder)new CannonWall(), (String[][])new String[][]{{"Peregrine"}}));
            result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new CannonWall(), (String[][])new String[][]{{"PurpleCheese"}}));
            result.add(new PlayerProfile(Race.Terran, (BuildOrder)new CannonWall(), (String[][])new String[][]{{"MadMix"}, {"Oyvind", "Johannessen"}}));
            result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new CannonWall(), (String[][])new String[][]{{"MadMix"}, {"Oyvind", "Johannessen"}}));
            result.add(new PlayerProfile(Race.Zerg, (BuildOrder)new CannonWall(), (String[][])new String[][]{{"MadMix"}, {"Oyvind", "Johannessen"}}));
            result.add(new PlayerProfile(Race.Zerg, (BuildOrder)new PvT(25), (String[][])new String[][]{{"AIlien"}}));
            result.add(new PlayerProfile(Race.Zerg, (BuildOrder)new CannonWall(), (String[][])new String[][]{{"KillAll"}}));
            result.add(new PlayerProfile(Race.Zerg, new CannonWall(), new String[][]{{"Zia"}}, ScoutGroup.unknown));
            result.add(new PlayerProfile(Race.Zerg, new CannonWall(), new String[][]{{"CasiaBot"}}, ScoutGroup.unknown));
            result.add(new PlayerProfile(Race.Unknown, new CannonWall(), new String[][]{{"UAlberta"}, {"Dave", "Churchill"}, {"David", "Churchill"}}, ScoutGroup.unknown));
        }
        result.add(new PlayerProfile(Race.Zerg, (BuildOrder)new CannonWall(true), (String[][])new String[][]{{"ZurZurZur"}}));
        if (Settings.getDebug()) {
            result.add(new PlayerProfile(Race.Zerg, (BuildOrder)new CannonWall(true), (String[][])new String[][]{{"Microwave"}}));
        } else {
            result.add(new PlayerProfile(Race.Zerg, new Strategy[]{new Strategy("FECANNONS", new CannonWall(true)), new Strategy("PvT", new PvT(25))}, (String[][])new String[][]{{"Microwave"}}));
        }
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new CannonWall(true, 6, true), (String[][])new String[][]{{"Lukas", "Moravec"}}));
        result.add(new PlayerProfile(Race.Zerg, (BuildOrder)new PvT(25).expandPush().delayUpgrades().prioritizeDragoons(), (String[][])new String[][]{{"Marian", "Devecka"}, {"Killer"}}));
        result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("GATEWAYTIMING", new GatewayPush())}, (String[][])new String[][]{{"tscmoo"}}));
        result.add(new PlayerProfile(Race.Zerg, (BuildOrder)new GatewayPush(), (String[][])new String[][]{{"tscmoo"}}));
        if (Settings.getDebug()) {
            result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("PvT", new PvT(25)), new Strategy("GATEWAYTIMING", new GatewayPush())}, (String[][])new String[][]{{"tscmoo"}}));
        } else {
            result.add(new PlayerProfile(Race.Terran, (BuildOrder)new GatewayPush(), (String[][])new String[][]{{"tscmoo"}}));
        }
        result.add(new PlayerProfile(Race.Unknown, new Strategy[]{new Strategy("GATEWAYTIMING", new GatewayPush()), new Strategy("ZP", new ZealotPush()), new Strategy("CANNONS", new CannonWall(false, 2))}, (String[][])new String[][]{{"tscmoo"}}));
        return result;
    }

    public static ArrayList<PlayerProfile> getTerranProfiles() {
        ArrayList<PlayerProfile> result = new ArrayList<PlayerProfile>();
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new TFastExpand(new DefensiveMech()), (String[][])new String[][]{{"Igor", "Lacik"}}));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new TFastExpand(new Mech(true)), (String[][])new String[][]{{"Marek", "Kadek"}}));
        result.add(new PlayerProfile(Race.Terran, new TFastExpand(new DefensiveMech(true)), new String[][]{{"Henri", "Kumpulainen"}}, ScoutGroup.unknown, new Task[]{new SalesmenMarinesTask()}));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new TFastExpand(new Mech(true)), (String[][])new String[][]{{"Rafal", "Poniatowski"}}));
        result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("BBS", new BBS()), new Strategy("MPUSH", new TAntiZealot(true, false, true, true))}, (String[][])new String[][]{{"tscmoo"}}));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new BBS(), (String[][])new String[][]{{"ICE"}}));
        result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("BBS", new BBS()), new Strategy("TvP", new TvPGeneric())}, (String[][])new String[][]{{"leta"}, {"Martin", "Rooijackers"}}));
        result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("BBS", new BBS())}, (String[][])new String[][]{{"Krasi"}}));
        result.add(new PlayerProfile(Race.Terran, new DefensiveMech(true, false, false), new String[][]{{"TerranUAB"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Terran, new DefensiveMech(), new String[][]{{"Oritaka"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Terran, new DefensiveMech(), new String[][]{{"Yarmouk"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Terran, new TFastExpand(new DefensiveMech(1, false, false, true)), new String[][]{{"Radim", "Bobek"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Terran, new AntiWorkerRush(), new String[][]{{"Stone"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("DROP", new AntiIron()), new Strategy("MPUSH", new TAntiZealot(true, false, true, true))}, (String[][])new String[][]{{"Iron"}, {"Igor", "Dimitrijevic"}}));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new BBS(), (String[][])new String[][]{{"Soeren", "Klett"}, {"Soren", "Klett"}, {"S\u00f6ren", "Klett"}, {"W.O.P.R."}, {"WOPR"}}));
        result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("BBS", new BBS())}, (String[][])new String[][]{{"Bereaver"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new TwoBaseMech(), (String[][])new String[][]{{"Aiur"}, {"Florian", "Richoux"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new DefensiveTerran(), (String[][])new String[][]{{"humanTest"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new TwoBaseMech(), (String[][])new String[][]{{"Vladimir", "Jurenka"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new TwoBaseMech(), (String[][])new String[][]{{"Roman", "Danielis"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new TFastExpand(new DefensiveMech(true)), (String[][])new String[][]{{"Skynet"}, {"Andrew", "Smith"}}));
        result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("MPUSH", new TAntiZealot(true, false, true, true)), new Strategy("FE", new TFastExpand(new TvPGeneric()))}, (String[][])new String[][]{{"Tomas", "Cere"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new OneBaseMech(), (String[][])new String[][]{{"Xelnaga"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new DefensiveMech(), (String[][])new String[][]{{"Susanoo"}}));
        result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("TC", new TankContain()), new Strategy("MPUSH", new TAntiZealot(true, false, true, true))}, (String[][])new String[][]{{"tscmoo"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new TAntiCannon(true), (String[][])new String[][]{{"Tomas", "Vajda"}, {"Thomas", "Vajda"}, {"XIMP"}}));
        result.add(new PlayerProfile(Race.Protoss, new TvP(), new String[][]{{"Jakub", "Trancik"}}, ScoutGroup.cannons));
        result.add(new PlayerProfile(Race.Unknown, new OneBaseTank(), new String[][]{{"UAlberta"}, {"Dave", "Churchill"}, {"David", "Churchill"}}, ScoutGroup.unknown, new Task[]{new SiegeNaturalTask()}));
        result.add(new PlayerProfile(Race.Unknown, (BuildOrder)new AntiKill(true), (String[][])new String[][]{{"Opprimo"}}));
        return result;
    }

    protected static void debug(ArrayList<PlayerProfile> result) {
        if (Settings.getDebug()) {
            result.get((int)(result.size() - 1)).triggerDebug = true;
        }
    }
}

