/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.agents.Agent;

/**
 * This class represents a single item in a solution list.
 * @author Simon
 *
 */
public abstract class SolutionItem extends Solution
{
	/**
	 * This class represents a single item in a solution list.
	 * @param task The task that started this solution.
	 */
	public SolutionItem(Task task)
	{
		super(task);
	}

	/**
	 * Is this solution done?
	 * @return
	 */
	public abstract boolean done();
	
	/**
	 * Add an agent to the list of agents.
	 * @param agent The agent to be added to the list.
	 */
	public abstract void add(Agent agent);
	
	/**
	 * Clear the solution of any agent, so that it can be removed.
	 */
	public abstract void clear();
	
	/**
	 * The number of agents in this solution item.
	 * @return The number of agents in this solution item.
	 */
	public abstract int size();
}
