/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.Tyr;

import bwapi.Game;
import bwapi.Player;

/**
 * This class implements a solution to a specific type of problem.
 */
public abstract class Solution 
{
	/**
	 * The task that is being solved.
	 */
	protected Task task;
	
	/**
	 * This class implements a solution to a specific type of problem.
	 * @param task The calling task.
	 */
	public Solution(Task task)
	{
		this.task = task;
	}
	
	/**
	 * When the solution has to be performed, this method will be called each frame.
	 * @param game The game.
	 * @param self The player controlled by our bot.
	 * @param bot The instance of Tyr that is currently playing the game.
	 */
	public abstract void onFrame(Game game, Player self, Tyr bot);
}
