/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import java.util.ArrayList;

import com.tyr.EnemyManager;
import com.tyr.Scanner;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.unitgroups.ScoutGroup;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import bwta.BaseLocation;


/**
 * A task that determines whether we are ready to attack the opponent.
 */
public class ScanTask extends Task
{
	private boolean startedClearBases = false;
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		if (solution != null)
		{
			if (((ScanSolution)solution).finishedScanning())
			{
				((ScanSolution)solution).clear(bot.hobos);
				solution = null;
			}
			else return true;
		}
		
		boolean noKnownEnemy = EnemyManager.getManager().enemyBuildingMemory.size() == 0 
				&& (Scanner.restart || bot.suspectedEnemy.size() == 1) 
				&& (Scanner.restart || game.isVisible(bot.suspectedEnemy.get(0).getTilePosition()));
		
		// We first add each expand back to the list of suspected enemy bases to see if we can find any enemy expands.
		if (noKnownEnemy && !startedClearBases)
		{
			startedClearBases = true;
			noKnownEnemy = false;
			for (BaseLocation expand : bot.expands)
				if (!expand.isIsland())
					bot.suspectedEnemy.add(expand);
			bot.expands = new ArrayList<BaseLocation>();
			ScoutGroup.clearEnemyExpands = true;
		}
		
		// We start looking for the enemy when we do not know the location of his buildings,
		// but only after we have checked his main base.
		return noKnownEnemy;
	}
	
	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		if (Scanner.restart && ((ScanSolution)solution).scanner.getGroundUnitCount() == 0)
			((ScanSolution)solution).scanner.addGround(bot.homeGroup.pop());
			
		// We call the super class, which will send the units out to defend.
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		solution = new ScanSolution(this);
		
		if (Scanner.restart)
			return;
		
		// Get all units from the home group to help search for the enemy.
		for(int i = bot.homeGroup.units.size() -1; i>= 0; i--)
		{
			Agent agent = bot.homeGroup.units.get(i);
			if (agent.unit.getType() != UnitType.Terran_Battlecruiser)
			{
				((ScanSolution)solution).add(agent);
				bot.homeGroup.units.remove(i);
			}
		}
		
		bot.scanner.startElimination();
	}
}
