/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.unitgroups.AttackGroup;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;

/**
 * This class implements a solution for pushing to secure an expansion.
 */
public class ExpandPushSolution extends Solution 
{
	/**
	 * The unit group of units that perform the harass.
	 */
	private AttackGroup attackGroup;
	
	/**
	 * The position where we move to to defend the expand.
	 */
	private Position target;
	
	/**
	 * This class implements a solution for harassing the opponents expands with vultures.
	 * @param task The task that started this solution.
	 * @param target The position where we move to to defend the expand.
	 */
	public ExpandPushSolution(Task task, Position target) 
	{
		super(task);
		this.target = target;
		attackGroup = new AttackGroup(target);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		if (target != null)
			Tyr.drawCircle(target, Color.Blue, 200);
		
		// Manage the harass group.
		attackGroup.cleanup();
		attackGroup.onFrame(game, self, bot);
	}

	/**
	 * Adds a unit to the group of harassing vultures.
	 * @param agent The unit to be added.
	 */
	public void add(Agent agent)
	{
		attackGroup.add(agent);
	}

	public int size()
	{
		return attackGroup.units.size();
	}
	
	public void clear()
	{
		attackGroup.clear();
	}

	public void setTarget(Position target)
	{
		this.target = target;
		attackGroup.setTarget(target);
	}
}
