/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import java.util.ArrayList;

import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * A task for harassing the opponents bases with a drop.
 */
public class DropHarassTask extends Task
{
	/**
	 * List of the types of units we want for the drop, including the dropship itself.
	 */
	UnitType[] requiredUnits = new UnitType[]{UnitType.Terran_Dropship, 
			UnitType.Terran_Vulture, 
			UnitType.Terran_Vulture, 
			UnitType.Terran_Vulture, 
			UnitType.Terran_Vulture};
	
	/**
	 * A task for harassing the opponents bases with a drop.
	 */
	public DropHarassTask() { }
	
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		if (solution != null)
		{
			if (((DropHarassSolution)solution).done())
			{
				((DropHarassSolution)solution).clear();
				solution = null;
			}
			else return true;
		}

		// We want there to be enough units left to defend.
		if (bot.homeGroup.units.size() < 10)
			return false;
			
		// We cannot start the harass if we cannot determine a target for the harass.
		if (EnemyManager.getManager().getOrderedExpands() == null)
			return false;
		
		boolean[] found = new boolean[requiredUnits.length];
		
		// For each type of unit we want, see if we have it.
		for(Agent agent : bot.homeGroup.units)
			for (int i=0; i<requiredUnits.length; i++)
				if (!found[i] && agent.unit.getType() == requiredUnits[i])
					found[i] = true;

		boolean success = true;
		
		for (int i=0; success && i < requiredUnits.length; i++)
			if (!found[i])
				success = false;
		
		return success;
	}
	
	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		// We call the super class, which will send the units out to defend.
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		boolean[] found = new boolean[requiredUnits.length];
		int count = 0;
		
		ArrayList<Agent> dropships = new ArrayList<Agent>();
		ArrayList<Agent> units = new ArrayList<Agent>();
		
		// Get the units needed for the harass.
		for(int a = bot.homeGroup.units.size() -1; count < found.length && a >= 0; a--)
		{
			Agent agent = bot.homeGroup.units.get(a);
			for (int i=0; i<requiredUnits.length; i++)
				if (!found[i] && agent.unit.getType() == requiredUnits[i])
				{
					found[i] = true;
					count++;
					if (agent.unit.getType() == UnitType.Terran_Dropship)
						dropships.add(agent);
					else
						units.add(agent);
					bot.homeGroup.units.remove(a);
					break;
				}
		}

		solution = new DropHarassSolution(this, dropships, units);
	}
}
