/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.BWTAProxy;
import com.tyr.Tyr;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * A task that constantly pushes the opponent.
 */
public class DragoonSquadTask extends Task
{
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		return true;
	}
	
	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		// If we find a new target to attack, we set that new target.
		if (!BWTAProxy.initialized)
			return;
		
		if (((DragoonSquadSolution)solution).count() == 0)
		{
			int dragoonCount = 0;
			boolean hasObserver = false;
			for (Agent agent : bot.homeGroup.units)
			{
				if (agent.unit.getType() == UnitType.Protoss_Dragoon)
					dragoonCount++;
				else if (agent.unit.getType() == UnitType.Protoss_Observer)
					hasObserver = true;
			}
			if (hasObserver && dragoonCount >= 8)
			{
				int dragoonsNeeded = 8;
				int observersNeeded = 1;
				for(int i = bot.homeGroup.units.size() - 1; i >= 0 && dragoonsNeeded + observersNeeded > 0; i--)
				{
					Agent agent = bot.homeGroup.units.get(i);
					if (agent.unit.getType() == UnitType.Protoss_Observer && observersNeeded > 0)
					{
						observersNeeded--;
						bot.homeGroup.units.remove(i);
						((DragoonSquadSolution)solution).add(agent);
					}
					else if (agent.unit.getType() == UnitType.Protoss_Dragoon && dragoonsNeeded > 0)
					{
						dragoonsNeeded--;
						bot.homeGroup.units.remove(i);
						((DragoonSquadSolution)solution).add(agent);
					}
				}
			}
		}
		
		// We call the super class, which will send the units out to attack.
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		solution = new DragoonSquadSolution(this);
	}
}
