/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.requirements;

import com.tyr.Tyr;
import com.tyr.UnitTracker;

import bwapi.UnitType;

/**
 * Is the number of units less than a linear function of the other type of unit.
 * @author Simon
 *
 */
public class LinearMax implements Requirement 
{
	/**
	 * The type of unit that is required.
	 */
	private UnitType typeReq;
	
	/**
	 * The type of unit for which we define a maximum.
	 */
	private UnitType typeMaxed;

	/**
	 * The value a in the linear function.
	 */
	private int a;
	
	/**
	 * The value b in the linear function.
	 */
	private int b;
	
	/**
	 * Does the building need to be finished, or is it enough for it to be constructing or for a BuildCommand to have been issued?
	 */
	private boolean finished;
	
	/**
	 * Is the number of units less than a linear function of the other type of unit.
	 * @param typeReq The type of unit that is required.
	 * @param typeMaxed The type of unit for which we define a maximum.
	 * @param a The value a in the linear function.
	 * @param b The value b in the linear function.
	 * @param finished Does the building need to be finished, or is it enough for it to be constructing or for a BuildCommand to have been issued?
	 */
	public LinearMax(UnitType typeReq, UnitType typeMaxed, int a, int b, boolean finished)
	{
		this.typeReq = typeReq;
		this.typeMaxed = typeMaxed;
		this.a = a;
		this.b = b;
		this.finished = finished;
	}
	
	@Override
	public boolean met()
	{
		if (finished)
			return UnitTracker.count(typeMaxed) < a*Tyr.self.completedUnitCount(typeReq) + b;
		else
			return UnitTracker.count(typeMaxed) < a*UnitTracker.count(typeReq) + b;
	}
}
