/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;


public class TFastExpand extends CompositeBuildOrder
{
	BuildOrder contained;
	boolean expanded = false;
	boolean takeGasNext = true;
	
	public TFastExpand(BuildOrder contained)
	{
		this.contained = contained;
	}
	
	public TFastExpand(BuildOrder contained, boolean takeGasNext)
	{
		this.contained = contained;
		this.takeGasNext = takeGasNext;
	}
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		if(contained != null)
			contained.initialize(game, self, bot);

		super.add(new SupplyDepotPart());
		super.add(new ExpandPart(takeGasNext));
		
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		if (expanded)
		{
			contained.onFrame(game, self, bot);
			return;
		}
		
		DebugMessages.addMessage("Going for early expand.");
		
		super.onFrame(game, self, bot);
		
		if (UnitTracker.getCcCount() >= 2)
			expanded = true;
	}

	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if (expanded)
			return contained.overrideStructureOrder(game, self, bot, agent);
		else
			return super.overrideStructureOrder(game, self, bot, agent);
	}
}
