/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Tyr;
import com.tyr.UnitTracker;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


public class ProtossTech extends CompositeBuildOrder
{
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		this.add(new WorkerScoutPart(1600));
		this.add(new ExpandPart());
		
		super.initialize(game, self, bot);
	}
	

	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		//if we're running out of supply and have enough minerals ...
		if ((self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() 
					<= UnitTracker.count(UnitType.Protoss_Gateway)*3 + UnitTracker.getCcCount() * 3)
				&& (bot.getAvailableMinerals() >= 100)
				&& self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400)
		{
			bot.spaceManager.build(UnitType.Protoss_Pylon);
		}
		
		//if we've the resources to build a Gateway ...
		if (bot.getAvailableMinerals()>= 150 && UnitTracker.count(UnitType.Protoss_Gateway) < 2*UnitTracker.count(UnitType.Protoss_Nexus)) 
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		//if we've the resources to build a Cybernetics Core...
		if (bot.getAvailableMinerals()>= 150 && UnitTracker.count(UnitType.Protoss_Gateway) >= 1
				&& UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1) 
		{
			bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
		}
		
		if(bot.getAvailableMinerals()>= 100 && UnitTracker.count(UnitType.Protoss_Assimilator) == 0 && UnitTracker.count(UnitType.Protoss_Gateway) >= 1) 
		{
			bot.spaceManager.build(UnitType.Protoss_Assimilator);
		}
	}
}
