/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import bwapi.UpgradeType;


public class OneBaseWraith extends CompositeBuildOrder
{
	int dropshipCount = 0;

	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(40);
		Settings.setMaximumSize(60);
		
		
		this.add(new SupplyDepotPart());
		this.add(new WorkerScoutPart(1600));
		
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		DebugMessages.addMessage("Going Wraiths.");
		
		if (bot.getAvailableGas() >= 400)
			Settings.setWorkersPerGas(UnitTracker.count(UnitType.Terran_Factory) >= 1?2:1);
		else if (bot.getAvailableGas() <= 300)
			Settings.setWorkersPerGas(UnitTracker.count(UnitType.Terran_Factory) >= 1?3:2);
		
		//if we've the resources to build a barracks ...
		if(bot.getAvailableMinerals()>= 150
				&& (UnitTracker.count(UnitType.Terran_Barracks) < 1)) 
		{
			bot.spaceManager.build(UnitType.Terran_Barracks);
		}
		
		if(bot.getAvailableMinerals()>= 100 
				&& UnitTracker.count(UnitType.Terran_Refinery) == 0
				&& UnitTracker.count(UnitType.Terran_Barracks) >= 1) 
		{
			bot.spaceManager.build(UnitType.Terran_Refinery);
		}
		
		if (bot.getAvailableMinerals() >= 150 
				&& UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0
				&& UnitTracker.count(UnitType.Terran_Academy) == 0
				&& UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0
				&& UnitTracker.count(UnitType.Terran_Wraith) >= 5)
		{
			bot.spaceManager.build(UnitType.Terran_Academy);
		}
		
		if(bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Factory) < 1)
		{
			bot.spaceManager.build(UnitType.Terran_Factory);
		}
		
		if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Terran_Starport) < 2)
		{
			bot.spaceManager.build(UnitType.Terran_Starport);
		}
	}
	
	@Override 
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if(super.overrideStructureOrder(game, self, bot, agent))
			return true;
		
		if(agent.unit.getType() == UnitType.Terran_Factory)
		{
			return true;
		}
		if(agent.unit.getType() == UnitType.Terran_Barracks)
		{
			return true;
		}
		else if (agent.unit.getType() == UnitType.Terran_Science_Facility)
		{
			if (!agent.unit.isResearching() && agent.unit.getAddon() == null && bot.getAvailableGas() >= 50 && bot.getAvailableMinerals() >= 50)
				agent.unit.buildAddon(UnitType.Terran_Physics_Lab);
		}
		else if (agent.unit.getType() == UnitType.Terran_Engineering_Bay)
		{
			return true;
		}
		else if(agent.unit.getType() == UnitType.Terran_Armory)
		{
			if(bot.getAvailableMinerals() >= UpgradeType.Terran_Ship_Weapons.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Terran_Ship_Weapons.gasPrice())
				agent.unit.upgrade(UpgradeType.Terran_Ship_Weapons);
			
			if(bot.getAvailableMinerals() >= UpgradeType.Terran_Ship_Plating.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Terran_Ship_Plating.gasPrice())
				agent.unit.upgrade(UpgradeType.Terran_Ship_Plating);
			
			return true;
		}
		return false;
	}

}
