/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.unitgroups.ScoutGroup;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.TechType;
import bwapi.UnitType;
import bwapi.UpgradeType;


public class GreedyBC extends CompositeBuildOrder
{
	int dropshipCount = 0;
	AntiWorkerRush antiWorker = null;
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(40);
		Settings.setMaximumSize(60);
		Settings.setDefensiveTanks(4);
		
		this.add(new SupplyDepotPart());
		this.add(new WorkerScoutPart(1600));
		this.add(new ExpandPart());
		
		super.initialize(game, self, bot);
	}

	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		if (bot.scout.opponentStrategy == ScoutGroup.workerRush)
		{
			if (antiWorker == null)
			{
				antiWorker = new AntiWorkerRush();
				antiWorker.initialize(game, self, bot);
			}
			antiWorker.onFrame(game, self, bot);
			return;
		}
		
		DebugMessages.addMessage("Going BattleCruiser.");
		
		if (bot.scout.opponentStrategy == ScoutGroup.besiege)
		{
			bot.scout.scoutCount = 2;
		}
		
		if (bot.getAvailableGas() >= 400)
			Settings.setWorkersPerGas(UnitTracker.count(UnitType.Terran_Factory) >= 1?2:1);
		else if (bot.getAvailableGas() <= 300)
			Settings.setWorkersPerGas(UnitTracker.count(UnitType.Terran_Factory) >= 1?3:2);
		else
			Tyr.drawCircle(new Position(self.getStartLocation().getX()*32 + 64, self.getStartLocation().getY()*32 + 32), Color.White, 64);
		
		//if we've the resources to build a barracks ...
		if(bot.getAvailableMinerals()>= 150
				&& UnitTracker.count(UnitType.Terran_Command_Center) >= 2
				&& (UnitTracker.count(UnitType.Terran_Barracks) < (game.enemy().getRace() == Race.Protoss?2:1))) 
		{
			bot.spaceManager.build(UnitType.Terran_Barracks);
		}
		
		if(UnitTracker.getGeyserCount() > 0 && bot.getAvailableMinerals()>= 100 
				&& (UnitTracker.count(UnitType.Terran_Refinery) == 0
				|| ( UnitTracker.count(UnitType.Terran_Refinery) < UnitTracker.count(UnitType.Terran_Command_Center) && UnitTracker.count(UnitType.Terran_Starport) > 0)) 
				&& UnitTracker.count(UnitType.Terran_Barracks) >= 1
				&& UnitTracker.count(UnitType.Terran_Bunker) >= (game.enemy().getRace() == Race.Protoss?2:1)) 
		{
			bot.spaceManager.build(UnitType.Terran_Refinery);
		}
		
		if(bot.getAvailableMinerals()>= 125 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 1 && UnitTracker.count(UnitType.Terran_Starport) >= 1) 
		{
			bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
		}
		
		if (bot.getAvailableMinerals() >= 150 
				&& UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0
				&& UnitTracker.count(UnitType.Terran_Academy) == 0
				&& UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0
				&& bot.homeGroup.units.size() >= 10
				&& UnitTracker.count(UnitType.Terran_Command_Center) >= 2)
		{
			bot.spaceManager.build(UnitType.Terran_Academy);
		}
		
		if (bot.getAvailableMinerals() >= 100 
				&& UnitTracker.count(UnitType.Terran_Barracks) >= 1 
				&& bot.scout.opponentStrategy != ScoutGroup.workerRush)
		{
			for(DefensiveStructures structures : bot.defensiveStructures)
			{
				if (structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) < 128
						&& UnitTracker.count(UnitType.Terran_Factory) == 0)
					continue;
					
				
				int count = structures.getUnitCount(UnitType.Terran_Bunker);
				
				if(count < (game.enemy().getRace() == Race.Protoss?2:1))
				{
					bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
		  			break;
				}
			}
		}
		
		if(bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Factory) < 2)
		{
			bot.spaceManager.build(UnitType.Terran_Factory);
		}
		
		if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) +  UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 2
				&& UnitTracker.count(UnitType.Terran_Command_Center) >= 2
				&& UnitTracker.count(UnitType.Terran_Starport) < 3
				&& (UnitTracker.count(UnitType.Terran_Starport) < 1 || (UnitTracker.count(UnitType.Terran_Battlecruiser) >= 1 && bot.getAvailableGas() >= 400)))
		{
			bot.spaceManager.build(UnitType.Terran_Starport);
		}
		
		if (UnitTracker.count(UnitType.Terran_Starport) >= 1 && UnitTracker.count(UnitType.Terran_Science_Facility) == 0
				&& bot.getAvailableGas() >= 150 && bot.getAvailableMinerals() >= 100)
		{
			bot.spaceManager.build(UnitType.Terran_Science_Facility);
		}

		if(UnitTracker.count(UnitType.Terran_Engineering_Bay) >= 1 && bot.getAvailableMinerals() >= 75)
		{
			for(DefensiveStructures structures : bot.defensiveStructures)
			{
				int count = structures.getUnitCount(UnitType.Terran_Missile_Turret);
				
				if(count == 0 && structures.defences.size() > 0)
				{
					bot.spaceManager.buildDefensive(UnitType.Terran_Missile_Turret, structures);
		  			break;
				}
			}
		}
		
		if (UnitTracker.count(UnitType.Terran_Battlecruiser) >= 3
				&& UnitTracker.count(UnitType.Terran_Armory) < 2
				&& bot.getAvailableGas() >= 50
				&& bot.getAvailableMinerals() >= 100)
		{
			bot.spaceManager.build(UnitType.Terran_Armory);
		}
	}
	
	@Override 
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if(super.overrideStructureOrder(game, self, bot, agent))
			return true;
		
		if (agent.unit.getType() == UnitType.Terran_Command_Center 
				&& bot.getAvailableMinerals() < 100 
				&& bot.scout.opponentStrategy == ScoutGroup.workerRush)
			return true;
		
		if(agent.unit.getType() == UnitType.Terran_Factory)
		{
			int neededTanks = 2*dropshipCount;
			neededTanks += Settings.getDefensiveTanks() * bot.defensiveStructures.size();
			
			if(agent.unit.getAddon() == null 
					&& bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50)
				agent.unit.buildAddon(UnitType.Terran_Machine_Shop);
			else if(!agent.unit.isTraining() && bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100
					&& UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode)
						< neededTanks
					&& (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) == 0 || self.hasResearched(TechType.Tank_Siege_Mode)))
				agent.unit.train(UnitType.Terran_Siege_Tank_Tank_Mode);
			else if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 500 && UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode)
					>= neededTanks)
				agent.unit.train(UnitType.Terran_Vulture);
			return true;
		}
		else if (agent.unit.getType() == UnitType.Terran_Starport)
		{
			if (agent.unit.getAddon() == null 
					&& bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50)
				agent.unit.buildAddon(UnitType.Terran_Control_Tower);
			else if (!agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_Dropship) < dropshipCount
					&& bot.getAvailableMinerals() >= 100&& bot.getAvailableGas() >= 100
					&& agent.unit.getAddon() != null)
				agent.unit.train(UnitType.Terran_Dropship);
			else if(!agent.unit.isTraining() && bot.getAvailableMinerals() >= 400 && bot.getAvailableGas() >= 300 && UnitTracker.count(UnitType.Terran_Physics_Lab) >= 1)
				agent.unit.train(UnitType.Terran_Battlecruiser);
			return true;
		}
		else if (agent.unit.getType() == UnitType.Terran_Science_Facility)
		{
			if (!agent.unit.isResearching() && agent.unit.getAddon() == null && bot.getAvailableGas() >= 50 && bot.getAvailableMinerals() >= 50)
				agent.unit.buildAddon(UnitType.Terran_Physics_Lab);
		}
		else if (agent.unit.getType() == UnitType.Terran_Engineering_Bay)
		{
			return true;
		}
		else if (agent.unit.getType() == UnitType.Terran_Physics_Lab)
		{
			if(!agent.unit.isResearching() 
					&& ! agent.unit.isUpgrading()
					&& bot.getAvailableGas() >= 150 && bot.getAvailableMinerals() >= 150)
				agent.unit.upgrade(UpgradeType.Colossus_Reactor);
			else if(!agent.unit.isResearching() 
					&& ! agent.unit.isUpgrading()
					&& bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 100)
				agent.unit.research(TechType.Yamato_Gun);
			
			return true;
		}
		else if(agent.unit.getType() == UnitType.Terran_Armory)
		{
			if(bot.getAvailableMinerals() >= UpgradeType.Terran_Ship_Weapons.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Terran_Ship_Weapons.gasPrice())
				agent.unit.upgrade(UpgradeType.Terran_Ship_Weapons);
			
			if(bot.getAvailableMinerals() >= UpgradeType.Terran_Ship_Plating.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Terran_Ship_Plating.gasPrice())
				agent.unit.upgrade(UpgradeType.Terran_Ship_Plating);
			
			return true;
		}
		return false;
	}

}
