/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.tasks.ConstantPushSolution;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.DefendMainTask;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import bwapi.UpgradeType;


public class FakeDT extends CompositeBuildOrder
{
	private ConstantPushTask constantPushTask;

	private boolean transition;
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(100);
		Settings.setMaximumSize(100);
		Settings.setMaximumWorkers(20);
		Settings.setLargeInvasionDist(768);

		this.add(new WorkerScoutPart(1600));

		constantPushTask = new ConstantPushTask(UnitType.Protoss_Dark_Templar, ConstantPushSolution.PRIORITIZE);
				bot.taskManager.potentialTasks.add(constantPushTask);
		Attack.dontWaitAtCannon = true;
		
		DefendMainTask.keepZealotsBack = true;
		
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		Settings.setWorkersPerGas(3);
		
		if (!transition && completed(DARK_TEMPLAR) > 0)
		{
			transition = true;
			constantPushTask.stop = true;
			Settings.setMaximumWorkers(40);


			constantPushTask = new ConstantPushTask(null, ConstantPushSolution.DISTRIBUTE);
			constantPushTask.stop = true;
			bot.taskManager.potentialTasks.add(constantPushTask);
		}
		
		if (transition)
		{
			if (armySize() <= 10)
				constantPushTask.stop = true;
			if (armySize() >= 15)
				constantPushTask.stop = false;
		}
		
		//if we're running out of supply and have enough minerals ...
		if ((self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() 
					<= UnitTracker.count(UnitType.Protoss_Gateway)*3 + UnitTracker.getCcCount() * 3)
				&& (bot.getAvailableMinerals() >= 100)
				&& self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400)
		{
			bot.spaceManager.build(UnitType.Protoss_Pylon);
		}
		
		//if we've the resources to build a Gateway ...
		if (bot.getAvailableMinerals()>= 150 
				&& (UnitTracker.count(UnitType.Protoss_Gateway) < 1 || bot.getAvailableMinerals() >= 300)
				&& (UnitTracker.count(UnitType.Protoss_Gateway) < 2 || transition)
				&& UnitTracker.count(UnitType.Protoss_Gateway) < 4) 
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		//if we've the resources to build a Gateway ...
		if (bot.getAvailableMinerals()>= 250 
				&& transition
				&& (UnitTracker.count(UnitType.Protoss_Gateway) >= 4)
				&& UnitTracker.count(UnitType.Protoss_Gateway) < 7) 
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		if (bot.getAvailableMinerals() >= 150
				&& UnitTracker.count(UnitType.Protoss_Forge) == 0
				&& transition
				&& completed(DRAGOON) + completed(ZEALOT) >= 20)
		{
			bot.spaceManager.build(UnitType.Protoss_Forge);
		}
		
		if(UnitTracker.count(UnitType.Protoss_Assimilator) < 2
				&& bot.getAvailableMinerals() >= 100 
				&& UnitTracker.getGeyserCount() > 0
				&& UnitTracker.count(UnitType.Protoss_Gateway) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Assimilator);
		}
		
		if (bot.getAvailableMinerals()>= 200 
				&& UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1
				&& self.completedUnitCount(UnitType.Protoss_Gateway) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
		}
		
		if (bot.getAvailableMinerals() >= 150
				&& bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Protoss_Citadel_of_Adun) < 1
				&& self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Citadel_of_Adun);
		}
		
		if (bot.getAvailableMinerals() >= 150
				&& bot.getAvailableGas() >= 200
				&& UnitTracker.count(UnitType.Protoss_Templar_Archives) < 1
				&& self.completedUnitCount(UnitType.Protoss_Citadel_of_Adun) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Templar_Archives);
		}
		
		if (gas() >= 200 && minerals() >= 200
				&& count(ROBOTICS_FACILITY) < 1
				&& count(GATEWAY) >= 2
				&& armySize() >= 2)
		{
			bot.spaceManager.build(ROBOTICS_FACILITY);
		}
		
		if (gas() >= 50 && minerals() >= 100
				&& completed(ROBOTICS_FACILITY) > 0
				&& count(OBSERVATORY) == 0)
		{
			bot.spaceManager.build(OBSERVATORY);
		}
	}
	
	private static int armySize()
	{
		return completed(ZEALOT) + completed(DRAGOON) + completed(DARK_TEMPLAR);
	}
	
	private boolean pauseProduction()
	{
		if (armySize() >= 2
				&& count(GATEWAY) > 2
				&& completed(CYBERNETICS_CORE) > 0
				&& count(ROBOTICS_FACILITY) == 0)
			return true;
		if (armySize() >= 2
				&& completed(CYBERNETICS_CORE) > 0
				&& completed(ROBOTICS_FACILITY) == 1
				&& count(OBSERVATORY) == 0)
			return true;
		if (armySize() >= 2
				&& completed(CYBERNETICS_CORE) > 0
				&& completed(OBSERVATORY) == 1
				&& count(OBSERVER) == 0)
			return true;
		return false;
	}
	
	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot,
			Agent agent)
	{
		if (agent.unit.getType() == UnitType.Protoss_Gateway)
		{
			if (pauseProduction())
				return true;
			if (!agent.unit.isTraining())
			{
				if (!transition)
				{
					if (self.completedUnitCount(UnitType.Protoss_Templar_Archives) > 0)
						agent.unit.train(UnitType.Protoss_Dark_Templar);
					else if (bot.getAvailableMinerals() >= 250 
							&& gas() >= 50
							&& (gas() >= 150 || count(DRAGOON) < 2))
						agent.unit.train(DRAGOON);
				}
				else
				{
					if (self.completedUnitCount(UnitType.Protoss_Templar_Archives) > 0
							&& UnitTracker.count(UnitType.Protoss_Dark_Templar) < 2)
						agent.unit.train(UnitType.Protoss_Dark_Templar);
					else if ((UnitTracker.count(UnitType.Protoss_Zealot) <= UnitTracker.count(UnitType.Protoss_Dragoon) || self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) == 0)
							&& bot.getAvailableMinerals() >= 100)
						agent.unit.build(UnitType.Protoss_Zealot);
					else if (UnitTracker.count(UnitType.Protoss_Zealot) > UnitTracker.count(UnitType.Protoss_Dragoon)
							&& bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50)
						agent.unit.build(UnitType.Protoss_Dragoon);
				}
			}
			return true;
		}
		else if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading())
		{
			if(bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice())
				agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
			
			if(bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice())
				agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
		}
		else if (agent.unit.getType() == UnitType.Protoss_Citadel_of_Adun && !agent.unit.isUpgrading())
		{
			if (bot.getAvailableGas() >= UpgradeType.Leg_Enhancements.gasPrice()
					&& bot.getAvailableMinerals() >= UpgradeType.Leg_Enhancements.mineralPrice())
				agent.unit.upgrade(UpgradeType.Leg_Enhancements);
		}
		else if (agent.unit.getType() == ROBOTICS_FACILITY)
		{
			if ((count(OBSERVER) < 3)
					&& minerals() >= 25
					&& gas() >= 75
					&& !agent.unit.isTraining())
				agent.unit.build(OBSERVER);
			return true;
		}
		return super.overrideStructureOrder(game, self, bot, agent);
	}
}
