/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.tasks.ConstantPushSolution;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.CorsairHarassTask;
import com.tyr.unitgroups.PrioritizedAttackGroup;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import bwapi.UpgradeType;


public class CorsairHarass extends CompositeBuildOrder
{
	private boolean hasAntiAir = false;
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(100);
		Settings.setMaximumSize(100);
		Settings.setMaximumWorkers(7);
		Settings.setWorkersPerGas(3);

		this.add(new WorkerScoutPart(1600));
		this.add(new ExpandPart(true));
		
		//if (game.enemy().getRace() != Race.Terran)
		//	bot.taskManager.potentialTasks.add(RunbyTask.getTask());
		PrioritizedAttackGroup.allowRetreat = true;
		
		
		Attack.requiredAtCannon = 0;

		bot.taskManager.potentialTasks.add(new CorsairHarassTask());
		bot.taskManager.potentialTasks.add(new ConstantPushTask(null, ConstantPushSolution.PRIORITIZE));
		
		
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);

		if (UnitTracker.count(UnitType.Protoss_Forge) > 0)
			Settings.setMaximumWorkers(40);
		else if (UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0)
			Settings.setMaximumWorkers(30);
		else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 4)
			Settings.setMaximumWorkers(25);
		else if (UnitTracker.count(UnitType.Protoss_Zealot) >= 2)
			Settings.setMaximumWorkers(20);
		else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 2)
			Settings.setMaximumWorkers(9);
		
		if (EnemyManager.getManager().getEnemyTypes().contains(UnitType.Zerg_Scourge))
			hasAntiAir = true;
		if (EnemyManager.getManager().getAllCount(UnitType.Zerg_Hydralisk) >= 2)
			hasAntiAir = true;
		
		
		if (UnitTracker.count(UnitType.Protoss_Probe) >= 7 && UnitTracker.count(UnitType.Protoss_Pylon) == 0 && bot.getAvailableMinerals() >= 100)
		{
			bot.spaceManager.build(UnitType.Protoss_Pylon);
		}
		
		if (self.completedUnitCount(UnitType.Protoss_Pylon) > 0 && bot.getAvailableMinerals() >= 250 && UnitTracker.count(UnitType.Protoss_Gateway) == 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		if (UnitTracker.count(UnitType.Protoss_Gateway) == 1 && bot.getAvailableMinerals() >= 100)
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		//if we're running out of supply and have enough minerals ...
		if ((self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() 
					<= UnitTracker.count(UnitType.Protoss_Gateway)*3 + UnitTracker.getCcCount() * 3)
				&& (bot.getAvailableMinerals() >= 100)
				&& self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400
				&& UnitTracker.count(UnitType.Protoss_Pylon) >= 1
				&& (UnitTracker.count(UnitType.Protoss_Zealot) >= 2 || self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() < 4))
		{
			bot.spaceManager.build(UnitType.Protoss_Pylon);
		}
		
		if(UnitTracker.count(UnitType.Protoss_Assimilator) < 2
				&& bot.getAvailableMinerals() >= 100 
				&& UnitTracker.getGeyserCount() > 0
				&& UnitTracker.count(UnitType.Protoss_Gateway) >= 2
				&& UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0
				)
		{
			bot.spaceManager.build(UnitType.Protoss_Assimilator);
		}
		
		if (bot.getAvailableMinerals() >= 200 
				&& UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1
				&& (UnitTracker.count(UnitType.Protoss_Zealot) >= 2)
				)
		{
			bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
		}
		
		if (bot.getAvailableMinerals() >= 150
				&& UnitTracker.count(UnitType.Protoss_Nexus) >= 2
				&& UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0
				&& UnitTracker.count(UnitType.Protoss_Forge) == 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Forge);
		}
		
		if (bot.getAvailableMinerals() >= 150
				&& bot.getAvailableGas() >= 150
				&& UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0
				&& UnitTracker.count(UnitType.Protoss_Stargate) == 0
				&& !hasAntiAir)
		{
			bot.spaceManager.build(UnitType.Protoss_Stargate);
		}
		
		if (bot.getAvailableMinerals() >= 300
				&& UnitTracker.count(UnitType.Protoss_Gateway) < 7
				&& (UnitTracker.count(UnitType.Protoss_Gateway) < 3 || UnitTracker.count(UnitType.Protoss_Forge) > 0))
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}

		if (bot.getAvailableGas() >= 200 && bot.getAvailableMinerals() >= 200
				&& UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0
				&& UnitTracker.count(UnitType.Protoss_Gateway) >= 3
				&& UnitTracker.count(UnitType.Protoss_Robotics_Facility) == 0
				&& hasAntiAir)
		{
			bot.spaceManager.build(UnitType.Protoss_Robotics_Facility);
		}

		if (bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 150
				&& self.completedUnitCount(UnitType.Protoss_Robotics_Facility) > 0
				&& UnitTracker.count(UnitType.Protoss_Robotics_Support_Bay) == 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Robotics_Support_Bay);
		}
	}
	
	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining())
		{
			if (!hasAntiAir && self.completedUnitCount(UnitType.Protoss_Stargate) > 0 && UnitTracker.count(UnitType.Protoss_Corsair) == 0)
				return true;
			
			if (UnitTracker.count(UnitType.Protoss_Nexus) < 2 && UnitTracker.count(UnitType.Protoss_Zealot) > 5 && UnitTracker.count(UnitType.Protoss_Corsair) >= 3)
				return true;
			
			if ((UnitTracker.count(UnitType.Protoss_Zealot) <= UnitTracker.count(UnitType.Protoss_Dragoon) || self.completedUnitCount(UnitType.Protoss_Corsair) == 0)
					&& bot.getAvailableMinerals() >= 100)
				agent.unit.build(UnitType.Protoss_Zealot);
			else if (UnitTracker.count(UnitType.Protoss_Zealot) > UnitTracker.count(UnitType.Protoss_Dragoon)
					&& bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50)
				agent.unit.build(UnitType.Protoss_Dragoon);
			return true;
		}
		else if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading())
		{
			if(bot.getAvailableMinerals() >= UpgradeType.Singularity_Charge.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Singularity_Charge.gasPrice())
				agent.unit.upgrade(UpgradeType.Singularity_Charge);
		}
		else if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading())
		{
			if(bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice())
				agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
			
			if(bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice())
				agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
		}
		else if (agent.unit.getType() == UnitType.Protoss_Stargate && !agent.unit.isTraining())
		{
			if (!hasAntiAir && bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100)
				agent.unit.build(UnitType.Protoss_Corsair);
			return true;
		}
		else if (agent.unit.getType() == UnitType.Protoss_Robotics_Facility)
		{
			if (bot.getAvailableMinerals() >= 200
					&& bot.getAvailableGas() >= 100
					&& !agent.unit.isTraining())
				agent.unit.build(UnitType.Protoss_Reaver);
		}
		return false;
	}
}
