/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.tasks.DefendMainTask;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


public class AntiWorkerRushProtoss extends CompositeBuildOrder
{
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(100);
		Settings.setMaximumSize(100);
		Settings.setMaximumWorkers(20);
		
		DefendMainTask.workerRush = true;
		
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		if (UnitTracker.count(UnitType.Protoss_Zealot) >= 2)
			Settings.setMaximumWorkers(20);

		if (UnitTracker.count(UnitType.Protoss_Probe) >= 7 && UnitTracker.count(UnitType.Protoss_Pylon) == 0 && bot.getAvailableMinerals() >= 100)
		{
			bot.spaceManager.build(UnitType.Protoss_Pylon);
		}
		
		if (self.completedUnitCount(UnitType.Protoss_Pylon) > 0 && bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Protoss_Gateway) == 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		//if we're running out of supply and have enough minerals ...
		if ((self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() 
					<= UnitTracker.count(UnitType.Protoss_Gateway)*3 + UnitTracker.getCcCount() * 3)
				&& (bot.getAvailableMinerals() >= 100)
				&& self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400
				&& UnitTracker.count(UnitType.Protoss_Pylon) >= 1)
		{
			bot.spaceManager.build(UnitType.Protoss_Pylon);
		}
	}
	
	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if (agent.unit.getType() == UnitType.Protoss_Nexus
				&& UnitTracker.count(UnitType.Protoss_Probe) >= 20)
			return true;
		if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining())
		{
			if (bot.getAvailableMinerals() >= 100)
				agent.unit.build(UnitType.Protoss_Zealot);
			return true;
		}
		return false;
	}
}
