/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.buildingplacement;

import com.tyr.Tyr;
import com.tyr.agents.Agent;

import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;

/**
 * Build site locator for finding a building placement where buildings are built very close together.
 * @author Simon
 *
 */
public class CompactBuildSite extends BuildSiteLocator 
{
	private static final int stopDist = 40;
	
	@Override
	public TilePosition findPlacement(UnitType building, TilePosition preferredTile, Agent worker)
	{
		// Find a suitable tile position for placing the building.
		if(preferredTile == null)
			preferredTile = Tyr.self.getStartLocation();
		
		return getBuildTile(worker.unit, building, preferredTile);
	}
	
    /**
     * Gets a suitable build poition for the building.
     * @param builder The worker who will build the building.
     * @param buildingType The type of building to be built.
     * @param aroundTile The tile around which we look for a suitable position.
     * @return The TilePosition where the building can be built.
     */
	public TilePosition getBuildTile(Unit builder, UnitType buildingType, TilePosition aroundTile) 
	{
		int maxDist = 3;
		// Just look in an increasing area around the desired position until we find something.
		while (maxDist < stopDist)
		{
			
			for (int i=aroundTile.getX()-maxDist; i<=aroundTile.getX()+maxDist; i++)
				for (int j=aroundTile.getY()-maxDist; j<=aroundTile.getY()+maxDist; j++)
					if(SpaceManager.canBuildHere(builder, i, j, buildingType))
						return new TilePosition(i, j);
			
			maxDist++;
		}
		return null;
 	}
}
