/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.agents;

import com.tyr.Tyr;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;


/**
 * Orders the unit to place a single spider mine.
 * @author Simon
 *
 */
public class PlaceMine extends Command
{
	/**
	 * The position where we will place our spider mine.
	 */
	private Position target;
	
	/**
	 * Has the vulture been ordered to place the spider mine yet?
	 */
	private boolean ordered = false;
	
	/**
	 * Constructor for the place spider mine.
	 * @param agent The agent that will place the mine. Must be a vulture.
	 * @param target The position where we will place the mine.
	 */
	public PlaceMine(Agent agent, Position target)
	{
		super(agent);
		this.target = target;
	}
	
	@Override
	public void execute(Game game, Player self, Tyr bot) 
	{
		VultureAgent vulture = (VultureAgent)agent;
		if (vulture.isBlocked)
		{
			// When the vulture is blocked in, we set the order for the agent to None.
			// This will make sure a new vulture will be found to place the next mine.
			agent.order(new None(agent));
			return;
		}
		
		game.drawLineMap(vulture.unit.getX(), vulture.unit.getY(), target.getX(), target.getY(), Color.Orange);
		Tyr.drawCircle(target, Color.Orange);
		game.drawTextMap(vulture.unit.getX(), vulture.unit.getY() + 8, vulture.unit.getOrder().toString());
		
		// If the order has not been given yet, order the vulture to place the spider mine.
		if (!ordered)
		{
			vulture.placeMine(target);
			ordered = true;
			return;
		}
		
		if (vulture.unit.isIdle())
		{
			// If the vulture was order to place a mine ten or more times,
			// It must have failed to place those mines, so we mark the unit as blocked in.
			if (vulture.getPlaceMineOrders() >= 10)
				vulture.isBlocked = true;
			
			// If the vulture is done, we remove the current command.
			vulture.blockedTimer = -1;
			vulture.order(new None(vulture));
			return;
		}
	}
	
	@Override
	public boolean replace(Command command) 
	{
		return true;
	}
	
}
