package com.tyr;

import bwapi.Position;
import bwapi.Unit;

/**
 * Utility class for doing some common operations using Positions.
 * @author Simon
 *
 */
public class PositionUtil 
{
	public static int distanceSq(Position p1, Position p2)
	{
		return (p1.getX() - p2.getX()) * (p1.getX() - p2.getX()) + (p1.getY() - p2.getY()) * (p1.getY() - p2.getY());
	}
	
	public static int distanceSq(Unit u, Position pos)
	{
		return distanceSq(u.getPosition(), pos);
	}
	
	public static int distanceSq(Position pos, Unit u)
	{
		return distanceSq(u.getPosition(), pos);
	}
	
	public static int distanceSq(Unit u1, Unit u2)
	{
		return distanceSq(u1.getPosition(), u2.getPosition());
	}

	public static Position getWeighted(Position p1, Position p2, double d)
	{
		return new Position((int)(p2.getX() * d + p1.getX() * (1.0 - d)), (int)(p2.getY() * d + p1.getY() * (1.0 - d)));
	}
}
