/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/

package com.tyr;

import java.util.ArrayList;

import com.tyr.buildingplacement.SpaceManager;

import bwapi.Position;
import bwta.BaseLocation;

public class OrderedExpands 
{
	/**
	 * List of all expands, in the order that they are encountered in a sweep around the map.
	 */
	private ArrayList<Position> orderedExpands;
	
	/**
	 * The currently 'active' expand in the list of expands.
	 */
	private int currentPos;

	/**
	 * The direction in which we are going through the list of ordered expands.
	 */
	private int dir;
	
	boolean includeIslands;
	
	boolean includeEnemyMain;
	
	boolean includeEnemyNatural;
	
	public OrderedExpands(boolean includeIslands, boolean includeEnemyMain, boolean includeEnemyNatural, boolean clockwise)
	{
		this.includeIslands = includeIslands;
		this.includeEnemyMain = includeEnemyMain;
		this.includeEnemyNatural = includeEnemyNatural;
		dir = clockwise ? -1 : 1;
	}
	
	/**
	 * Try to initialize the OrderedExpands.
	 * @return Returns true if successful, false otherwise.
	 */
	public boolean tryInitialize()
	{
		if (orderedExpands != null && orderedExpands.size() > 0)
			return true;

		if (Tyr.bot.suspectedEnemy.size() != 1 && (!includeEnemyNatural || includeEnemyMain))
			return false;
		
		final ArrayList<Position> newOrderedExpands = EnemyManager.getManager().getOrderedExpands();
		
		if (newOrderedExpands == null || newOrderedExpands.size() == 0)
			return false;
		
		
		orderedExpands = new ArrayList<Position>();
		for (Position pos : newOrderedExpands)
		{
			if (!includeIslands)
			{
				boolean isIsland = false;
				for(BaseLocation b : Tyr.bot.expands)
					if (b.isIsland() && PositionUtil.distanceSq(b.getPosition(), pos) <= 10000)
					{
						isIsland = true;
						break;
					}
				if (isIsland)
					continue;
			}
			orderedExpands.add(pos);
		}
		
		if (!includeEnemyNatural)
		{
			final Position enemyNatural = SpaceManager.getEnemyNatural().getPosition();
			int enemyNat = 0;
			for (; enemyNat < orderedExpands.size() -1; enemyNat++)
				if (PositionUtil.distanceSq(enemyNatural, orderedExpands.get(enemyNat)) <= 100 * 100)
					break;
			orderedExpands.remove(enemyNat);
		}
		
		if (includeEnemyMain)
			orderedExpands.add(Tyr.bot.suspectedEnemy.get(0).getPosition());

		// Start from the main.
		for(int pos = 0; pos < orderedExpands.size(); pos++)
		{
			if (orderedExpands.get(pos).getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) <= 100)
			{
				currentPos = pos;
				break;
			}
		}
		
		return true;
	}
	
	public Position getPos()
	{
		return orderedExpands.get(currentPos);
	}
	
	public void next()
	{
		currentPos = (currentPos + dir + orderedExpands.size()) % orderedExpands.size();
	}
	
	public void reverseDir()
	{
		dir = -dir;
	}
}
