/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/

package com.tyr;

import java.util.ArrayList;
import java.util.List;

import bwapi.Position;
import bwapi.TilePosition;
import bwta.BWTA;
import bwta.BaseLocation;
import bwta.Chokepoint;
import bwta.Region;


/**
 * This class is used to initalize BWTA on a separate thread.
 * @author Simon
 *
 */
public class BWTAProxy implements Runnable
{
	/**
	 * True iff BWTA has been initialized.
	 */
	public static boolean initialized = false;

	@Override
	public void run()
	{
        //Use BWTA to analyze map
        //This may take a few minutes if the map is processed first time!
		try
		{
			Tyr.bot.expands = new ArrayList<BaseLocation>();
			Tyr.bot.suspectedEnemy = new ArrayList<BaseLocation>();
			
			// Begin analysing the map.
	        System.out.println("Analyzing map...");
	        BWTA.analyze();
	        System.out.println("Map data ready");
	        
	        // Determine the expand locations and the possible enemy bases.
	        for(BaseLocation bloc : BWTA.getBaseLocations())
	        {
	        	if(!bloc.isStartLocation() || Tyr.self.getStartLocation().getDistance(bloc.getTilePosition()) < 4)
	        		Tyr.bot.expands.add(bloc);
	        	else
	        		Tyr.bot.suspectedEnemy.add(bloc);
	        }
	        
	        initialized = true;
			DebugMessages.log("Map analyzed: " + Tyr.game.mapFileName());
		}
		catch(Exception e)
		{
			System.out.println("Error intializing BWTA: " + e.getMessage());
			Tyr.game.printf("Error intializing BWTA: " + e.getMessage());
		}
	}
	
	public static void readMap()
	{
		System.out.println("Reading map...");
        BWTA.readMap();
        System.out.println("Map is read...");
	}

	/**
	 * Returns the region containing the given position.
	 * @param position The position for which we want to get the region. 
	 * @return The region containing the given position.
	 */
	public static Region getRegion(Position position) 
	{
		if (initialized)
			return BWTA.getRegion(position);
		else
			return null;
	}

	/**
	 * Returns the region containing the given tile position.
	 * @param position The tile position for which we want to get the region. 
	 * @return The region containing the given tile position.
	 */
	public static Region getRegion(TilePosition position) 
	{
		if (initialized)
			return BWTA.getRegion(position);
		else
			return null;
	}

	public static List<BaseLocation> getStartLocations() 
	{
		if (initialized)
			return BWTA.getStartLocations();
		else
			return null;
	}

	public static double getGroundDistance(TilePosition p1, TilePosition p2) 
	{
		if (p1 == null)
			throw new NullPointerException("TilePosition p1 was null.");
		if (p2 == null)
			throw new NullPointerException("TilePosition p2 was null.");
		if (initialized)
			return BWTA.getGroundDistance(p1, p2);
		else
			return -1;
	}

	public static List<Chokepoint> getChokepoints()
	{
		if (!initialized)
			return null;
		return BWTA.getChokepoints();
	}
}
