/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds.listbuildorder;

import java.util.HashMap;
import java.util.List;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;

import com.tyr.Tyr;
import com.tyr.builds.CompositeBuildOrder;

public abstract class ListBuildOrder extends CompositeBuildOrder
{
	public abstract List<List<BuildPart>> getBuild();
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		for (List<BuildPart> buildList : getBuild())
		{
			final HashMap<UnitType, Integer> alreadyBuilt = new HashMap<>();
			
			for (BuildPart part : buildList)
			{
				if (part instanceof Requirement)
				{
					if (!((Requirement)part).met())
						break;
				}
				else if (part instanceof Building)
				{
					Building building = (Building)part;
					if (getBuilt(alreadyBuilt, building.type) + building.count <= count(building.type))
						continue;
					
					if (minerals() >= building.type.mineralPrice() && gas() >= building.type.gasPrice())
						build(building.type);
					return;
				}
			}
		}
	}
	
	public int getBuilt(HashMap<UnitType, Integer> alreadyBuilt, UnitType type)
	{
		if (!alreadyBuilt.containsKey(type))
			return 0;
		else
			return alreadyBuilt.get(type);
	}
}
