/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.buildingplacement.DefensiveStructures;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


public class TvZ extends CompositeBuildOrder
{
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		bot.bunkers.minimumRepair = 2;
		
		this.add(new WorkerScoutPart(1600));
		this.add(new ExpandPart());
		this.add(new SupplyDepotPart());
		
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		if (bot.bunkers.bunkers.size() == 1 && bot.homeGroup.units.size() >= 11 && bot.homeGroup.units.size() < 15 && !bot.bunkers.disabled)
			bot.bunkers.disabled = true;
		
		if ((bot.homeGroup.units.size() < 11 || bot.homeGroup.units.size() >= 19) && bot.bunkers.disabled)
			bot.bunkers.disabled = false;
		
        //if we've the resources to build a barracks ...
        if (((bot.getAvailableMinerals()>= 150 
        		&& (bot.homeGroup.units.size() > 0 || UnitTracker.count(UnitType.Terran_Barracks) == 0  || bot.getAvailableMinerals()>= 200)))
        		&& (UnitTracker.count(UnitType.Terran_Barracks) < Math.min(UnitTracker.getCcCount() * 2 + 1, 10))) 
        	bot.spaceManager.build(UnitType.Terran_Barracks);
        
        if(UnitTracker.getGeyserCount() > 0 && bot.getAvailableMinerals()>= 100 && UnitTracker.count(UnitType.Terran_Refinery) == 0
        		&& UnitTracker.count(UnitType.Terran_Barracks) == 4) 
        {
      	  bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        
        if(bot.getAvailableMinerals()>= 125 && UnitTracker.count(UnitType.Terran_Refinery) > 0
        		&& UnitTracker.count(UnitType.Terran_Engineering_Bay) < 1) 
        {
      	  bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
        }

		
		if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1)
		{
			for(DefensiveStructures structures : bot.defensiveStructures)
			{
				int count = structures.getUnitCount(UnitType.Terran_Bunker);
				
				if(count < 1)
				{
		  			bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
		  			break;
				}
			}
		}
	}
}
