/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.ConstantPushTask;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;


/**
 * Build order designed to counter mass cannon builds.
 * @author Simon
 *
 */
public class TAntiCannon extends CompositeBuildOrder
{
	public boolean cannonRushDetected = false;
	private boolean doWorkerScout;

	public TAntiCannon()
	{ }
	
	public TAntiCannon(boolean doWorkerScout)
	{
		this.doWorkerScout = doWorkerScout;
	}
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setWorkersPerGas(2);
		Settings.setMaximumWorkers(15);
		bot.taskManager.potentialTasks.add(new ConstantPushTask(UnitType.Terran_Siege_Tank_Tank_Mode));
		bot.bunkers.disabled = true;
		
		if (doWorkerScout)
			this.add(new WorkerScoutPart(1600));
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		Tyr.drawCircle(new Position(self.getStartLocation().getX()*32 + 64, self.getStartLocation().getY()*32 + 32), Color.Yellow, 64);
		
		//if we're running out of supply and have enough minerals ...
		if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() 
					<= UnitTracker.count(UnitType.Terran_Barracks) *3 + UnitTracker.getCcCount() * 3
				&& (bot.getAvailableMinerals() >= 100)
				&& self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400)
		{
			if (UnitTracker.count(UnitType.Terran_Supply_Depot) == 0
					&& bot.defensiveStructures.size() >= 1)
			{
				Position desiredPos = SpaceManager.getMainExit();
				if (desiredPos != null)
				{
					Position baseDir = Tyr.tileToPosition(self.getStartLocation());
					baseDir = new Position(baseDir.getX() - desiredPos.getX(), baseDir.getY() - desiredPos.getY());
					double length = Math.sqrt(baseDir.getX() * baseDir.getX() + baseDir.getY() * baseDir.getY());
					desiredPos = new Position((int)(desiredPos.getX() + baseDir.getX()*200/length), (int)(desiredPos.getY() + baseDir.getY()*200/length));
					bot.spaceManager.build(UnitType.Terran_Supply_Depot, desiredPos);
				}
				else
					bot.spaceManager.build(UnitType.Terran_Supply_Depot);
			}
			else
				bot.spaceManager.build(UnitType.Terran_Supply_Depot);
		}
		
		//if we've the resources to build a barracks ...
		if(bot.getAvailableMinerals()>= 100 
				&& (UnitTracker.count(UnitType.Terran_Barracks) == 0 || bot.getAvailableMinerals() >= 150)
				&& UnitTracker.count(UnitType.Terran_Refinery) >= 1
				&& ((UnitTracker.count(UnitType.Terran_Barracks) < 1) || !cannonRushDetected)
				&& ((UnitTracker.count(UnitType.Terran_Barracks) < 1) || (bot.getAvailableMinerals()>= 300))
				&& (UnitTracker.count(UnitType.Terran_Barracks) < Math.min(UnitTracker.getCcCount() * 4, 10)))
		{
			bot.spaceManager.build(UnitType.Terran_Barracks);
		}
		
		if(bot.getAvailableMinerals()>= 150 
				&& (UnitTracker.count(UnitType.Terran_Barracks) < Math.min(UnitTracker.getCcCount() * 2, 10))
				&& (bot.getAvailableMinerals() >= 200 || UnitTracker.count(UnitType.Terran_Barracks) < 1)
				&& UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 5) 
		{
			bot.spaceManager.build(UnitType.Terran_Barracks);
		}
		
		if(bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Factory) < 1)
		{
			bot.spaceManager.build(UnitType.Terran_Factory);
		}
		
		if(UnitTracker.getGeyserCount() > 0 
				&& bot.getAvailableMinerals()>= 100 
				&& UnitTracker.count(UnitType.Terran_Refinery) == 0
				&& UnitTracker.count(UnitType.Terran_Supply_Depot) > 0) 
		{
			bot.spaceManager.build(UnitType.Terran_Refinery);
		}
	}
	
	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) 
	{
		if (super.overrideStructureOrder(game, self, bot, agent))
			return true;
		
		if (agent.unit.getType() == UnitType.Terran_Factory)
			return UnitTracker.countTanks() >= 5;
		return false;
	}
}
