/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Tyr;
import com.tyr.UnitTracker;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * This BuildOrder builds supply depots when the bot runs out of supply.
 * This is meant to be used as a part of a larger build using the CompositeBuildOrder class.
 */
public class SupplyDepotPart extends BuildOrder
{
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		
		if (
				// The remaining supply.
				(self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed()
						<= 
						// Estimate for the supply that will be used
						(	UnitTracker.count(UnitType.Terran_Barracks)
						  + UnitTracker.getCcCount()
						  + UnitTracker.count(UnitType.Terran_Starport)
						  + UnitTracker.count(UnitType.Terran_Factory)
						)
					* 3)
					// Do we have enough minerals?
				&& (bot.getAvailableMinerals() >= 100)
					// We do not need more than the maximum supply.
				&& self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400)
		{
			bot.spaceManager.build(UnitType.Terran_Supply_Depot);
		}
	}
}
