/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.requirements.ConjRequirement;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * This BuildOrder builds one specific type of building at the desired time.
 * This is meant to be used as a part of a larger build using the CompositeBuildOrder class.
 */
public class GenericPart extends BuildOrder
{
	/**
	 * What type of building do we build?
	 */
	private UnitType building;
	
	/**
	 * How many minerals are required to build the building?
	 */
	private int requiredMinerals;
	
	/**
	 * How much gas is required to build the building?
	 */
	private int requiredGas;
	
	/**
	 * The maximum number of this building that we build
	 */
	private int maximum = 1;
	
	/**
	 * Additional requirements that need to be met for us to build the building.
	 */
	private ConjRequirement requirements;
	
	/**
	 * This BuildOrder builds one specific type of building at the desired time.
	 * This is meant to be used as a part of a larger build using the CompositeBuildOrder class.
	 * @param building What type of building do we build?
	 * @param maximum The maximum number of this building that we build
	 * @param minerals How many minerals are required to build the building?
	 * @param gas How much gas is required to build the building?
	 * @param requirements Additional requirements that need to be met for us to build the building.
	 */
	public GenericPart(UnitType building, int maximum, int minerals, int gas, ConjRequirement requirements)
	{
		super();
		
		this.building = building;
		this.maximum = maximum;
		this.requiredMinerals = minerals;
		this.requiredGas = gas;
		this.requirements = requirements;
	}

	@Override
	public void initialize(Game game, Player self, Tyr bot) { }
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		if (UnitTracker.count(building) >= maximum)
			return;
		if (bot.getAvailableMinerals() < requiredMinerals || bot.getAvailableGas() < requiredGas)
			return;
		if (!requirements.met())
			return;
		
		bot.spaceManager.build(building);
	}
}
