/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.tasks.ConstantPushSolution;
import com.tyr.tasks.ConstantPushTask;
import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;


public class DTPush extends CompositeBuildOrder
{
	private boolean hasTurrets = false;
	private ConstantPushTask constantPushTask;

	private boolean cannonsDetected;
	private boolean transition;
	boolean dragoonDefense = false;
	boolean detectionNeeded = false;
	
	boolean groupDTs;
	
	public DTPush()
	{
		this(true);
	}
	
	public DTPush(boolean groupDTs)
	{
		super();
		this.groupDTs = groupDTs;
	}
	
	public DTPush(boolean groupDTs, boolean dragoonDefense)
	{
		super();
		this.groupDTs = groupDTs;
		this.dragoonDefense = dragoonDefense;
	}
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(100);
		Settings.setMaximumSize(100);
		Settings.setMaximumWorkers(20);

		this.add(new WorkerScoutPart(1600));
		this.add(new ExpandPart(true));

		constantPushTask = new ConstantPushTask(UnitType.Protoss_Dark_Templar, ConstantPushSolution.PRIORITIZE);
		bot.taskManager.potentialTasks.add(constantPushTask);
		Attack.dontWaitAtCannon = true;
		
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		Settings.setWorkersPerGas(3);
		
		if (!cannonsDetected && EnemyManager.getManager().getEnemyTypes().contains(UnitType.Protoss_Photon_Cannon))
			cannonsDetected = true;
		
		if (!detectionNeeded)
		{
			for (Unit unit : EnemyManager.getEnemyUnits())
				if (unit.isLifted() && unit.getType() == UnitType.Terran_Command_Center)
				{
					detectionNeeded = true;
					break;
				}
		}
		
		
		final boolean baseDestroyed = EnemyManager.getManager().enemyBuildingMemory.isEmpty() && UnitTracker.count(UnitType.Protoss_Dark_Templar) > 8;
		
		if (!transition && (cannonsDetected || baseDestroyed))
		{
			transition = true;
			constantPushTask.stop = true;
			Settings.setMaximumWorkers(40);


			constantPushTask = new ConstantPushTask(null);
			constantPushTask.stop = true;
			bot.taskManager.potentialTasks.add(constantPushTask);
		}
		
		if (transition)
		{
			int zealots = self.completedUnitCount(UnitType.Protoss_Zealot);
			int dragoons = self.completedUnitCount(UnitType.Protoss_Dragoon);
			if (zealots + dragoons <= 10)
				constantPushTask.stop = true;
			if (zealots + dragoons >= 20)
				constantPushTask.stop = false;
		}
		
		if (!hasTurrets)
			hasTurrets = EnemyManager.getManager().getEnemyTypes().contains(UnitType.Terran_Missile_Turret);
		
		if (constantPushTask != null && !cannonsDetected)
			constantPushTask.stop = groupDTs && hasTurrets && UnitTracker.count(UnitType.Protoss_Dark_Templar) <= 8;
		
		//if we're running out of supply and have enough minerals ...
		if ((self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() 
					<= UnitTracker.count(UnitType.Protoss_Gateway)*3 + UnitTracker.getCcCount() * 3)
				&& (bot.getAvailableMinerals() >= 100)
				&& self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400)
		{
			bot.spaceManager.build(UnitType.Protoss_Pylon);
		}
		
		//if we've the resources to build a Gateway ...
		if (bot.getAvailableMinerals()>= 150 
				&& (UnitTracker.count(UnitType.Protoss_Gateway) < 1 || bot.getAvailableMinerals() >= 300)
				&& (UnitTracker.count(UnitType.Protoss_Gateway) < 2 || UnitTracker.count(UnitType.Protoss_Nexus) >= 2)
				&& UnitTracker.count(UnitType.Protoss_Gateway) < 4) 
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		//if we've the resources to build a Gateway ...
		if (bot.getAvailableMinerals()>= 250 
				&& transition
				&& UnitTracker.count(UnitType.Protoss_Nexus) >= 2
				&& (UnitTracker.count(UnitType.Protoss_Gateway) >= 4)
				&& UnitTracker.count(UnitType.Protoss_Gateway) < 7) 
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		if (bot.getAvailableMinerals() >= 150
				&& UnitTracker.count(UnitType.Protoss_Forge) == 0
				&& transition
				&& UnitTracker.count(UnitType.Protoss_Nexus) >= 2)
		{
			bot.spaceManager.build(UnitType.Protoss_Forge);
		}
			
		
		if(UnitTracker.count(UnitType.Protoss_Assimilator) < 2
				&& bot.getAvailableMinerals() >= 100 
				&& UnitTracker.getGeyserCount() > 0
				&& UnitTracker.count(UnitType.Protoss_Gateway) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Assimilator);
		}
		
		if (bot.getAvailableMinerals()>= 200 
				&& UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1
				&& self.completedUnitCount(UnitType.Protoss_Gateway) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
		}
		
		if (bot.getAvailableMinerals() >= 150
				&& bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Protoss_Citadel_of_Adun) < 1
				&& self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Citadel_of_Adun);
		}
		
		if (bot.getAvailableMinerals() >= 150
				&& bot.getAvailableGas() >= 200
				&& UnitTracker.count(UnitType.Protoss_Templar_Archives) < 1
				&& self.completedUnitCount(UnitType.Protoss_Citadel_of_Adun) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Templar_Archives);
		}
		
		if (gas() >= 200 && minerals() >= 200
				&& detectionNeeded
				&& count(ROBOTICS_FACILITY) < 1
				&& count(GATEWAY) >= 2)
		{
			bot.spaceManager.build(ROBOTICS_FACILITY);
		}
		
		if (gas() >= 50 && minerals() >= 100
				&& completed(ROBOTICS_FACILITY) > 0
				&& count(OBSERVATORY) == 0)
		{
			bot.spaceManager.build(OBSERVATORY);
		}
	}
	
	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot,
			Agent agent)
	{
		if (agent.unit.getType() == UnitType.Protoss_Gateway)
		{
			if (!agent.unit.isTraining())
			{
				if (!transition)
				{
					if (self.completedUnitCount(UnitType.Protoss_Templar_Archives) > 0)
						agent.unit.train(UnitType.Protoss_Dark_Templar);
					else if (bot.getAvailableMinerals() >= 250
							&& !dragoonDefense)
						agent.unit.train(UnitType.Protoss_Zealot);
					else if (bot.getAvailableMinerals() >= 250 
							&& gas() >= 50
							&& (gas() >= 150 || count(DRAGOON) < 2)
							&& dragoonDefense)
						agent.unit.train(DRAGOON);
				}
				else
				{
					if (self.completedUnitCount(UnitType.Protoss_Templar_Archives) > 0
							&& UnitTracker.count(UnitType.Protoss_Dark_Templar) == 0)
						agent.unit.train(UnitType.Protoss_Dark_Templar);
					else if ((UnitTracker.count(UnitType.Protoss_Zealot) <= UnitTracker.count(UnitType.Protoss_Dragoon) || self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) == 0)
							&& bot.getAvailableMinerals() >= 100)
						agent.unit.build(UnitType.Protoss_Zealot);
					else if (UnitTracker.count(UnitType.Protoss_Zealot) > UnitTracker.count(UnitType.Protoss_Dragoon)
							&& bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50)
						agent.unit.build(UnitType.Protoss_Dragoon);
				}
			}
			return true;
		}
		else if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading())
		{
			if(bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice())
				agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
			
			if(bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice())
				agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
		}
		else if (agent.unit.getType() == UnitType.Protoss_Citadel_of_Adun && !agent.unit.isUpgrading())
		{
			if (bot.getAvailableGas() >= UpgradeType.Leg_Enhancements.gasPrice()
					&& bot.getAvailableMinerals() >= UpgradeType.Leg_Enhancements.mineralPrice())
				agent.unit.upgrade(UpgradeType.Leg_Enhancements);
		}
		else if (agent.unit.getType() == ROBOTICS_FACILITY)
		{
			if ((count(OBSERVER) < 3)
					&& minerals() >= 25
					&& gas() >= 75
					&& !agent.unit.isTraining())
				agent.unit.build(OBSERVER);
			return true;
		}
		return super.overrideStructureOrder(game, self, bot, agent);
	}
}
