/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.UnitType;


/**
 * Implements an aggressive bio build with tank support.
 * @author Simon
 *
 */
public class BioMech extends CompositeBuildOrder
{
	/**
	 * Will the build take expands?
	 */
	boolean expandingEnabled = false;
	
	/**
	 * Implements an aggressive bio build with tank support.
	 */
	public BioMech()
	{}
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(15);
		Settings.setMaximumSize(60);
		
		Settings.setWorkersPerGas(1);
		
		this.add(new SupplyDepotPart());
		this.add(new WorkerScoutPart(1600));
		
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		DebugMessages.addMessage("Going bioMech.");
		
		StopWatch watch = new StopWatch();
		long time;
		watch.start();
		
		super.onFrame(game, self, bot);
		
		// If we are floating minerals, start taking expands.
		// This will also allow the build to  build more structures, giving a chance to spend the resources better.
		if (!expandingEnabled && bot.getAvailableMinerals() >= 800)
		{
			this.add(new ExpandPart());
			expandingEnabled = true;
		}
		
		time = watch.time();
		if (time > 55)
			DebugMessages.addMessage("BioMech super time: " + time); 
		
		if (UnitTracker.count(UnitType.Terran_Factory) > 0)
			Settings.setWorkersPerGas(2);
		
		//if we've the resources to build a barracks ...
		if (bot.getAvailableMinerals()>= 150 
				&& (UnitTracker.count(UnitType.Terran_Barracks) < Math.min(6, 2 * UnitTracker.getCcCount()))
				&& (UnitTracker.count(UnitType.Terran_Academy) > 0 || UnitTracker.count(UnitType.Terran_Barracks) < 2)
				&& (UnitTracker.count(UnitType.Terran_Barracks) == 0 
						|| (self.hasResearched(TechType.Tank_Siege_Mode) 
							&& UnitTracker.count(UnitType.Terran_Factory) > 0 
							&& UnitTracker.count(UnitType.Terran_Academy) > 0)
				&& (UnitTracker.count(UnitType.Terran_Refinery) > 0))
			)
		{
			bot.spaceManager.build(UnitType.Terran_Barracks);
		}

		time = watch.time();
		if (time > 55)
			DebugMessages.addMessage("BioMech tier 1 time: " + time);
		
		if (bot.getAvailableMinerals()>= 100 
				&& UnitTracker.getGeyserCount() > 0 
				&& (UnitTracker.count(UnitType.Terran_Refinery) == 0)
			)
		{
			bot.spaceManager.build(UnitType.Terran_Refinery);
		}

		time = watch.time();
		if (time > 55)
			DebugMessages.addMessage("BioMech refinery: " + time + " geyserCount: " + UnitTracker.getGeyserCount());
		
		if (bot.getAvailableMinerals() >= 150 
				&& UnitTracker.count(UnitType.Terran_Barracks) != 0
				&& UnitTracker.count(UnitType.Terran_Factory) != 0 
				&& UnitTracker.count(UnitType.Terran_Refinery) != 0
				&& UnitTracker.count(UnitType.Terran_Academy) == 0
			)
		{
			bot.spaceManager.build(UnitType.Terran_Academy);
		}
		
		if(bot.getAvailableMinerals()>= 125 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 2 
				&& UnitTracker.count(UnitType.Terran_Marine) >= 20
				&& UnitTracker.count(UnitType.Terran_Academy) > 0) 
		{
			bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
		}
		
		if (UnitTracker.count(UnitType.Terran_Barracks) > 0
				&& UnitTracker.count(UnitType.Terran_Factory) == 0
				&& bot.getAvailableGas() >= 100
				&& bot.getAvailableMinerals() >= 200)
		{
			bot.spaceManager.build(UnitType.Terran_Factory);
		}
		
		time = watch.time();
		if (time > 55)
			DebugMessages.addMessage("BioMech tier 2 time: " + time);
	}

	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if(super.overrideStructureOrder(game, self, bot, agent))
			return true;
		
		if (agent.unit.getType() == UnitType.Terran_Barracks)
		{
			if (!agent.unit.isTraining() 
					&& Tyr.bot.getAvailableGas() >= 25 && Tyr.bot.getAvailableMinerals() >= 50
					&& self.completedUnitCount(UnitType.Terran_Academy) > 0)
			{
				if (UnitTracker.count(UnitType.Terran_Medic) * 4 < 
						UnitTracker.count(UnitType.Terran_Marine) + UnitTracker.count(UnitType.Terran_Firebat) - 4 * UnitTracker.count(UnitType.Terran_Bunker))
				{
					agent.unit.train(UnitType.Terran_Medic);
					return true;
				}
				if (UnitTracker.count(UnitType.Terran_Firebat) <= 
						UnitTracker.count(UnitType.Terran_Marine))
				{
					agent.unit.train(UnitType.Terran_Firebat);
					return true;
				}
			}
		}
		else if (agent.unit.getType() == UnitType.Terran_Starport)
			return true;
		
		return false;
	}
}
